/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.BooleanRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.IOFilterListener;
import com.gamedash.daemon.process.childProcess.io.listener.IORelayListener;
import com.gamedash.daemon.process.childProcess.reference.ChildProcessReferences;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.generic.GenericTerminal;
import com.gamedash.daemon.process.childProcess.terminal.pty.PtyTerminal;
import com.gamedash.daemon.process.childProcess.terminal.windows.WindowsTerminal;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.system.user.SystemUsers;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateChildProcess
extends Route<Object> {
    private static final Logger logger = LoggerFactory.getLogger(CreateChildProcess.class);
    private final String executable;
    private final List<String> args;
    private final Boolean await;
    private final File workingDirectory;
    private final String referenceName;
    private final List<String> outputFilters;
    private final Map<String, String> environmentVariables;
    private final Boolean useShell;
    private final String systemUserName;
    private final String systemUserPassword;
    private final Boolean isSelfManaged;
    private ChildProcess childProcess;

    public CreateChildProcess(Request request, Response response) throws Exception {
        super(request, response);
        this.executable = this.request.getInput().getParameters().get("executable").getValue();
        this.args = this.request.getInput().getParameters().get("args").getList();
        this.await = this.request.getInput().getParameters().exists("await") ? this.request.getInput().getParameters().get("await").getValue(new BooleanRequestParameterTransformer()) : Boolean.valueOf(false);
        this.workingDirectory = this.getWorkingDirectory();
        this.referenceName = this.request.getInput().getParameters().exists("reference") ? this.request.getInput().getParameters().get("reference").getValue() : null;
        this.outputFilters = this.request.getInput().getParameters().exists("outputFilters") ? this.request.getInput().getParameters().get("outputFilters").getList() : new ArrayList<String>();
        this.environmentVariables = this.getEnvironmentVariables();
        this.useShell = this.request.getInput().getParameters().exists("useShell") ? this.request.getInput().getParameters().get("useShell").getValue(new BooleanRequestParameterTransformer()) : null;
        this.systemUserName = this.request.getInput().getParameters().exists("systemUserName") ? this.request.getInput().getParameters().get("systemUserName").getValue() : null;
        this.systemUserPassword = this.request.getInput().getParameters().exists("systemUserPassword") ? this.request.getInput().getParameters().get("systemUserPassword").getValue() : null;
        this.isSelfManaged = this.request.getInput().getParameters().exists("isSelfManaged") ? this.request.getInput().getParameters().get("isSelfManaged").getValue(new BooleanRequestParameterTransformer()) : null;
    }

    @Override
    public Result execute() throws Exception {
        this.childProcess = this.createChildProcess();
        this.childProcess.spawn(this.executable, this.args.toArray(new String[0]));
        if (this.await.booleanValue()) {
            AwaitedResult response = new AwaitedResult(this.childProcess.getId());
            this.childProcess.waitForExit();
            response.exitCode = this.childProcess.getExitCode();
            this.childProcess.getIo().getOutputItems().forEach(outputItem -> response.addOutputItem(new ResultIoOutputItem((OutputItem)outputItem)));
            this.childProcess.delete();
            return response;
        }
        return new Result(this.childProcess.getId());
    }

    private ChildProcess createChildProcess() throws Exception {
        List<String> relayChannelNames;
        ChildProcess process = ChildProcesses.create(this.getTerminalClass());
        if (this.isSelfManaged != null || this.await.booleanValue()) {
            if (this.await.booleanValue()) {
                process.setIsSelfManaged(false);
            } else {
                process.setIsSelfManaged(this.isSelfManaged);
            }
        }
        if (this.referenceName != null) {
            process.getReferences().createLocal(this.referenceName);
        }
        if (!this.await.booleanValue()) {
            process.setShouldReportCrashes(true);
        }
        if (this.workingDirectory != null) {
            process.setWorkingDirectory(this.workingDirectory);
        }
        if (this.environmentVariables != null) {
            process.setEnvironmentVariables(this.environmentVariables);
        }
        if (this.useShell != null) {
            process.setUseShell(this.useShell);
        }
        if (this.systemUserName != null) {
            SystemUser systemUser = SystemUsers.get(this.systemUserName);
            if (this.systemUserPassword != null) {
                systemUser.setStoredPassword(this.systemUserPassword);
            }
            process.setSystemUser(systemUser);
        }
        if ((relayChannelNames = this.getRelayChannelNames()) != null) {
            IORelayListener relayIoListener = new IORelayListener(process);
            for (String channelName : relayChannelNames) {
                relayIoListener.addChannel(channelName);
            }
            process.getIo().addListener(relayIoListener);
        }
        if (this.outputFilters != null) {
            process.getIo().addListener(new IOFilterListener(process, this.outputFilters));
        }
        process.getIo().setShouldAwait(this.await);
        return process;
    }

    private Map<String, String> getEnvironmentVariables() throws Exception {
        String jsonString;
        String string = jsonString = this.request.getInput().getParameters().exists("environmentVariables") ? this.request.getInput().getParameters().get("environmentVariables").getValue() : null;
        if (jsonString != null) {
            Gson gson = new Gson();
            return (Map)gson.fromJson(jsonString, new TypeToken<Map<String, String>>(){}.getType());
        }
        return null;
    }

    private File getWorkingDirectory() throws Exception {
        return this.request.getInput().getParameters().exists("workingDirectory") ? new File(this.request.getInput().getParameters().get("workingDirectory").getValue()) : null;
    }

    private Class<? extends ITerminal> getTerminalClass() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return WindowsTerminal.class;
        }
        if (this.request.getInput().getParameters().exists("terminal") && this.request.getInput().getParameters().get("terminal").getValue().equalsIgnoreCase("pty")) {
            return PtyTerminal.class;
        }
        return GenericTerminal.class;
    }

    private List<String> getRelayChannelNames() {
        if (!this.request.getInput().getParameters().exists("relayChannels")) {
            return null;
        }
        return this.request.getInput().getParameters().get("relayChannels").getList();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"executable", "args"};
    }

    @Override
    public void before() throws Exception {
        String referenceName;
        if (this.request.getInput().getParameters().exists("reference") && ChildProcessReferences.exists(referenceName = this.request.getInput().getParameters().get("reference").getValue())) {
            throw new Exception("Reference with name " + referenceName + " already exists");
        }
    }

    private static class ResultIoOutputItem {
        @SerializedName(value="index")
        private final long index;
        @SerializedName(value="isError")
        private final boolean isError;
        @SerializedName(value="value")
        private final String value;
        @SerializedName(value="timestampCreated")
        private final long timestampCreated;

        public ResultIoOutputItem(OutputItem outputItem) {
            this.index = outputItem.getIndex();
            this.isError = outputItem.isError();
            this.value = outputItem.getValue();
            this.timestampCreated = outputItem.getTimeCreated().getTimestamp();
        }
    }

    private static class AwaitedResult
    extends Result {
        @SerializedName(value="exitCode")
        public int exitCode;
        @SerializedName(value="output")
        private final List<ResultIoOutputItem> outputItems = new ArrayList<ResultIoOutputItem>();

        public AwaitedResult(int id) {
            super(id);
        }

        void addOutputItem(ResultIoOutputItem outputItem) {
            this.outputItems.add(outputItem);
        }
    }

    private static class Result {
        @SerializedName(value="id")
        protected long id;

        public Result(int id) {
            this.id = id;
        }
    }
}

