/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.compression;

import com.gamedash.daemon.api.server.model.fileSystem.file.group.ZipFileParameter;
import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.system.user.SystemUser;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class Zip
extends Route<String>
implements FileSystemSystemUserTrait {
    public Zip(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        Gson gson = new Gson();
        List groupFiles = (List)gson.fromJson(this.request.getInput().getParameters().get("files").getValue(), new TypeToken<List<ZipFileParameter>>(){}.getType());
        File destination = FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        if (destination.exists() && !destination.isFile()) {
            throw new FileNotFoundException("Destination file exists, but is a directory");
        }
        if (destination.exists()) {
            destination.delete();
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(destination));){
            zipOutputStream.setLevel(1);
            for (ZipFileParameter groupFile : groupFiles) {
                File file = FileUtils.fromBase64(groupFile.path);
                if (!file.exists()) {
                    throw new IOException("File " + file.getAbsolutePath() + " does not exist");
                }
                if (file.isDirectory()) {
                    this.compressDirectory(file, groupFile.name != null ? groupFile.name : groupFile.path, zipOutputStream);
                    continue;
                }
                this.compressFile(file, groupFile.name != null ? groupFile.name : file.getName(), zipOutputStream);
            }
        }
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            systemUser.assignFileSystemFilePermission(destination);
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files", "destination"};
    }

    private void compressFile(File file, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        zipOutputStream.putNextEntry(entry);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
        }
    }

    private void compressDirectory(File directory, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.compressDirectory(file, entryName + File.separator + file.getName(), zipOutputStream);
                continue;
            }
            this.compressFile(file, entryName + File.separator + file.getName(), zipOutputStream);
        }
    }

    private static String getEntryName(File destination, File file) {
        return destination.toURI().relativize(file.toURI()).getPath();
    }
}

