/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class Copy
extends Route<String>
implements FileSystemSystemUserTrait {
    public Copy(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        List<String> filePaths = this.request.getInput().getParameters().get("files").getList();
        File directory = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("directory").getValue());
        if (directory.exists() && !directory.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        for (String filePath : filePaths) {
            SystemUser systemUser;
            File file = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(filePath);
            File destination = new File(directory.getPath() + "/" + file.getName());
            if (file.isDirectory()) {
                FileUtils.copyDirectory(file, destination);
            } else {
                FileUtils.copyFile(file, destination);
            }
            if ((systemUser = this.getSystemUser(this.request, "systemUserName")) == null) continue;
            systemUser.assignFileSystemFilePermission(destination);
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files", "directory"};
    }
}

