/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents;

import com.gamedash.daemon.api.server.model.fileSystem.file.FileModel;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.filters.RootDirectoryFileFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class GetContents
extends Route<List<FileModel>> {
    public GetContents(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<FileModel> execute() throws Exception {
        File directory = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        List<File> files = this.getRootFiles(directory);
        ArrayList<FileModel> responseFiles = new ArrayList<FileModel>();
        for (File file : files) {
            if (file.toPath().compareTo(directory.toPath()) == 0) continue;
            responseFiles.add(new FileModel(directory, file));
        }
        return responseFiles;
    }

    protected List<File> getRootFiles(File directory) {
        RootDirectoryFileFilter filter = new RootDirectoryFileFilter(directory);
        return (List)FileUtils.listFilesAndDirs(directory, filter, filter);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

