/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory;

import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.filters.RootDirectoryFileFilter;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class MoveContents
extends Route<String>
implements FileSystemSystemUserTrait {
    public MoveContents(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = this.getOrigin();
        File destination = this.getDestination();
        if (!origin.exists() || !origin.isDirectory()) {
            throw new FileNotFoundException("Origin does not exist");
        }
        if (!destination.exists()) {
            destination.mkdir();
        } else if (!destination.isDirectory()) {
            throw new IOException("Destination is not a directory");
        }
        if (origin.compareTo(destination) == 0) {
            throw new FileNotFoundException("Can not move to the same directory");
        }
        this.moveFiles();
        return null;
    }

    private void moveFiles() throws Exception {
        File destination = this.getDestination();
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        for (File file : this.getRootFiles()) {
            File fileDestination = new File(destination, file.getName());
            if (fileDestination.exists()) {
                if (fileDestination.isDirectory()) {
                    FileUtils.deleteDirectory(fileDestination);
                } else {
                    fileDestination.delete();
                }
            }
            if (file.isDirectory()) {
                FileUtils.moveDirectory(file, fileDestination);
            } else {
                FileUtils.moveFile(file, fileDestination);
            }
            if (systemUser == null) continue;
            systemUser.assignFileSystemFilePermission(fileDestination);
        }
    }

    private List<File> getRootFiles() throws RequestParameterException {
        File origin = this.getOrigin();
        RootDirectoryFileFilter filter = new RootDirectoryFileFilter(origin);
        ArrayList<File> files = new ArrayList<File>();
        for (File file : FileUtils.listFilesAndDirs(origin, filter, filter)) {
            if (file.toPath().compareTo(origin.toPath()) == 0) continue;
            files.add(file);
        }
        return files;
    }

    private File getOrigin() throws RequestParameterException {
        return com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("origin").getValue());
    }

    private File getDestination() throws RequestParameterException {
        return com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

