/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.BooleanRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.filters.SymlinkIgnoringFileFilter;
import com.gamedash.daemon.fileSystem.file.filters.TrueFileFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class GetSize
extends Route<Long> {
    public GetSize(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Long execute() throws Exception {
        File directory = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        boolean shouldIgnoreSymlinks = this.shouldIgnoreSymlinks();
        long totalSize = 0L;
        List files = (List)FileUtils.listFilesAndDirs(directory, shouldIgnoreSymlinks ? SymlinkIgnoringFileFilter.instance : TrueFileFilter.instance, shouldIgnoreSymlinks ? SymlinkIgnoringFileFilter.instance : TrueFileFilter.instance);
        for (File file : files) {
            if (!file.isFile()) continue;
            totalSize += file.length();
        }
        return totalSize;
    }

    private boolean shouldIgnoreSymlinks() {
        if (this.request.getInput().getParameters().exists("ignoreSymlinks")) {
            return this.request.getInput().getParameters().get("ignoreSymlinks").getValue(new BooleanRequestParameterTransformer());
        }
        return true;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

