/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes;

import com.gamedash.daemon.build.Build;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.common.version.Version;
import com.gamedash.daemon.system.OperatingSystem;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Root
extends Route<Object> {
    private static final Logger logger = LoggerFactory.getLogger(Root.class);

    public Root(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        try {
            Result result = new Result();
            Version version = Build.getVersion();
            if (version != null) {
                result.version = new Result.VersionResult();
                result.version.id = version.getId();
                result.version.isLatest = version.isLatest();
            }
            result.system = new Result.System();
            result.system.operatingSystem = new Result.System.OperatingSystem();
            result.system.operatingSystem.uptime = OperatingSystem.getUptime();
            result.system.operatingSystem.buildNumber = OperatingSystem.getBuildNumber();
            result.system.operatingSystem.version = OperatingSystem.getVersion();
            result.system.operatingSystem.codeName = OperatingSystem.getCodeName();
            return result;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    private static class Result {
        @SerializedName(value="name")
        private final String name = "GameDash Daemon";
        @SerializedName(value="system")
        private System system;
        @SerializedName(value="version")
        private VersionResult version;

        private Result() {
        }

        private static class System {
            @SerializedName(value="operatingSystem")
            public OperatingSystem operatingSystem;

            private System() {
            }

            private static class OperatingSystem {
                @SerializedName(value="version")
                public String version;
                @SerializedName(value="codeName")
                public String codeName;
                @SerializedName(value="buildNumber")
                public String buildNumber;
                @SerializedName(value="uptime")
                public long uptime;

                private OperatingSystem() {
                }
            }
        }

        private static class VersionResult {
            @SerializedName(value="id")
            public String id;
            @SerializedName(value="isLatest")
            public boolean isLatest;

            private VersionResult() {
            }
        }
    }
}

