/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.ConnectException;
import com.gamedash.daemon.api.server.route.Routes;
import com.gamedash.daemon.fileSystem.file.FileAlreadyExistsException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionNotFoundException;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUserNotFoundException;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSessionNotFoundException;
import com.gamedash.daemon.network.port.PortDoesNotExistException;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.system.user.SystemUserNotFoundException;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServer
extends com.gamedash.daemon.common.api.server.ApiServer {
    private static final Logger logger = LoggerFactory.getLogger(ApiServer.class);
    private static final Gson gson = new Gson();
    private final Routes routes = new Routes(this);

    @Override
    public void start() throws Exception {
        super.start();
        this.getExceptionManager().createHandler(ProcessNotFoundException.class, 404).register();
        this.getExceptionManager().createHandler(ChildProcessNotFoundException.class, 404).register();
        this.getExceptionManager().createHandler(PortDoesNotExistException.class, 404).register();
        this.getExceptionManager().createHandler(ChildProcessNotRunningException.class, 404).register();
        this.getExceptionManager().createHandler(FileAlreadyExistsException.class, 409).register();
        this.getExceptionManager().createHandler(FileDownloaderSessionNotFoundException.class, 404).register();
        this.getExceptionManager().createHandler(SystemUserNotFoundException.class, 404).register();
        this.getExceptionManager().createHandler(RemoteFileSystemUserNotFoundException.class, 404).register();
        this.getExceptionManager().createHandler(StatusHandshakeSessionNotFoundException.class, 404).register();
        this.getExceptionManager().createHandler(ConnectException.class, 400).register();
        this.routes.register();
        this.onBefore((request, response) -> {
            if (Application.args.logApiRequests.booleanValue()) {
                String serializedParameters = gson.toJson(request.getInput().getParameters().getAll());
                logger.info("Received " + request.getSparkRequest().requestMethod() + " request for " + request.getSparkRequest().uri() + " with parameters " + serializedParameters);
            }
        });
    }
}

