/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.Args;
import com.gamedash.daemon.common.args.ArgsParser;
import com.gamedash.daemon.common.args.ParameterException;
import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            Args parsedArgs = new Args();
            new ArgsParser(parsedArgs).parse(args);
            if (parsedArgs.dev.booleanValue() || parsedArgs.runDirectly.booleanValue()) {
                logger.info("Running directly without wrapper");
                Application.setRootDirectory(Main.determineRootDirectory());
                Application application = new Application();
                application.run(args);
            } else {
                logger.error("Can not be ran directly");
                System.exit(1);
            }
        }
        catch (ParameterException e) {
            logger.error(e.getMessage());
            return;
        }
    }

    private static File determineRootDirectory() {
        return FileSystemHelpers.getOwnDirectory(Main.class);
    }
}

