/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.software.os.OSUser;
import oshi.util.ExecutingCommand;

public class LinuxUserGroupInfo {
    private Map<String, OSUser> usersIdMap = new HashMap<String, OSUser>();
    private Map<String, String> groupsIdMap = new HashMap<String, String>();

    public OSUser getUser(String userId) {
        OSUser user;
        if (this.usersIdMap.isEmpty()) {
            this.cacheUsers();
        }
        if ((user = this.usersIdMap.get(userId)) != null) {
            return user;
        }
        user = new OSUser();
        user.setUserId(userId);
        user.setUserName("Unknown");
        return user;
    }

    public String getGroupName(String groupId) {
        String group;
        if (this.groupsIdMap.isEmpty()) {
            this.cacheGroups();
        }
        return (group = this.groupsIdMap.get(groupId)) != null ? group : "Unknown";
    }

    private void cacheUsers() {
        List<String> passwd = ExecutingCommand.runNative("getent passwd");
        for (String entry : passwd) {
            String[] split = entry.split(":");
            if (split.length < 3) continue;
            String userName = split[0];
            String uid = split[2];
            if (this.usersIdMap.containsKey(uid)) continue;
            OSUser user = new OSUser();
            user.setUserId(uid);
            user.setUserName(userName);
            this.usersIdMap.put(uid, user);
        }
    }

    private void cacheGroups() {
        List<String> group = ExecutingCommand.runNative("getent group");
        for (String entry : group) {
            String[] split = entry.split(":");
            if (split.length < 3) continue;
            String groupName = split[0];
            String gid = split[2];
            if (this.groupsIdMap.containsKey(gid)) continue;
            this.groupsIdMap.put(gid, groupName);
        }
    }
}

