/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.function.Supplier;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

final class FreeBsdFirmware
extends AbstractFirmware {
    private final Supplier<DmidecodeStrings> readDmiDecode = Memoizer.memoize(this::readDmiDecode);

    FreeBsdFirmware() {
    }

    @Override
    public String getManufacturer() {
        return this.readDmiDecode.get().manufacturer;
    }

    @Override
    public String getVersion() {
        return this.readDmiDecode.get().version;
    }

    @Override
    public String getReleaseDate() {
        return this.readDmiDecode.get().releaseDate;
    }

    private DmidecodeStrings readDmiDecode() {
        String manufacturer = null;
        String version = null;
        String releaseDate = "";
        String manufacturerMarker = "Vendor:";
        String versionMarker = "Version:";
        String releaseDateMarker = "Release Date:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            if (checkLine.contains("Vendor:")) {
                manufacturer = checkLine.split("Vendor:")[1].trim();
                continue;
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Release Date:")) continue;
            releaseDate = checkLine.split("Release Date:")[1].trim();
        }
        releaseDate = ParseUtil.parseMmDdYyyyToYyyyMmDD(releaseDate);
        return new DmidecodeStrings(manufacturer, version, releaseDate);
    }

    private static final class DmidecodeStrings {
        private final String manufacturer;
        private final String version;
        private final String releaseDate;

        private DmidecodeStrings(String manufacturer, String version, String releaseDate) {
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.version = Util.isBlank(version) ? "unknown" : version;
            this.releaseDate = Util.isBlank(releaseDate) ? "unknown" : releaseDate;
        }
    }
}

