/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.linux.jni;

import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.platform.linux.jna.LinuxJnaNativeBridge;
import org.icmp4j.platform.linux.jni.Icmp4jJNI;
import org.icmp4j.util.JniUtil;

public class LinuxJniNativeBridge
extends NativeBridge {
    @Override
    public void initialize() {
        try {
            JniUtil.loadLibraryBestEffort("icmp4jJNI");
            Icmp4jJNI jniRequest = new Icmp4jJNI();
            String string = jniRequest.icmp_test();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            LinuxJnaNativeBridge newBridge = new LinuxJnaNativeBridge();
            ((NativeBridge)newBridge).initialize();
        }
    }

    @Override
    public IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        IcmpPingResponse response = new IcmpPingResponse();
        Icmp4jJNI jniRequest = new Icmp4jJNI();
        jniRequest.host = request.getHost();
        jniRequest.ttl = request.getTtl();
        jniRequest.packetSize = request.getPacketSize();
        jniRequest.timeOut = (int)request.getTimeout();
        long icmpSendEchoStartNanoTime = System.nanoTime();
        jniRequest.icmp_start();
        long icmpSendEchoNanoDuration = System.nanoTime() - icmpSendEchoStartNanoTime;
        long icmpSendEchoDuration = icmpSendEchoNanoDuration / 1000L / 1000L;
        response.setDuration(icmpSendEchoDuration);
        response.setSuccessFlag(jniRequest.retCode == 1);
        response.setTimeoutFlag(jniRequest.hasTimeout == 1);
        response.setErrorMessage(jniRequest.errorMsg);
        response.setHost(jniRequest.address);
        response.setSize(jniRequest.bytes);
        response.setRtt(jniRequest.rtt);
        response.setTtl(jniRequest.ttl);
        return response;
    }
}

