/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.icmp4j.AsyncCallback;
import org.icmp4j.Icmp4jUtil;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.platform.NativeBridge;

public class IcmpPingUtil {
    private static final AtomicInteger nextId = new AtomicInteger();

    public static IcmpPingRequest createIcmpPingRequest() {
        IcmpPingRequest request = new IcmpPingRequest();
        request.setHost("localhost");
        request.setPacketSize(32);
        request.setTimeout(5000L);
        request.setTtl(255);
        return request;
    }

    public static IcmpPingResponse createTimeoutIcmpPingResponse(long duration) {
        IcmpPingResponse response = new IcmpPingResponse();
        response.setErrorMessage("Timeout reached after " + duration + " msecs");
        response.setSuccessFlag(false);
        response.setTimeoutFlag(true);
        return response;
    }

    public static IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        Icmp4jUtil.initialize();
        String host = request.getHost();
        if (host == null) {
            throw new RuntimeException("host must be specified");
        }
        int packetSize = request.getPacketSize();
        if (packetSize == 0) {
            throw new RuntimeException("packetSize must be > 0: " + packetSize);
        }
        NativeBridge nativeBridge = Icmp4jUtil.getNativeBridge();
        IcmpPingResponse response = nativeBridge.executePingRequest(request);
        int rtt = response.getRtt();
        if (rtt == Integer.MAX_VALUE) {
            throw new RuntimeException("rtt should not be MAX_VALUE: " + rtt);
        }
        long timeout = request.getTimeout();
        if (timeout > 0L && (long)rtt > timeout) {
            throw new RuntimeException("rtt should not be > timeout: " + rtt + " / " + timeout);
        }
        return response;
    }

    public static void executePingRequest(final IcmpPingRequest request, final AsyncCallback<IcmpPingResponse> asyncCallback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    IcmpPingResponse response = IcmpPingUtil.executePingRequest(request);
                    asyncCallback.onSuccess(response);
                }
                catch (Throwable throwable) {
                    asyncCallback.onFailure(throwable);
                }
            }
        };
        int id = nextId.incrementAndGet();
        String name = "executePingRequest:id=" + id;
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    public static IcmpPingResponse executePingRequest(String host, int packetSize, long timeout) {
        IcmpPingRequest request = IcmpPingUtil.createIcmpPingRequest();
        request.setHost(host);
        request.setPacketSize(packetSize);
        request.setTimeout(timeout);
        return IcmpPingUtil.executePingRequest(request);
    }

    public static List<IcmpPingResponse> executePingRequests(IcmpPingRequest request, int packetCount) {
        ArrayList<IcmpPingResponse> responseList = new ArrayList<IcmpPingResponse>(packetCount);
        for (int i = 1; i < packetCount; ++i) {
            IcmpPingResponse response = IcmpPingUtil.executePingRequest(request);
            responseList.add(response);
        }
        return responseList;
    }

    public static String formatResponse(IcmpPingResponse response) {
        boolean successFlag = response.getSuccessFlag();
        String address = response.getHost();
        String message = response.getErrorMessage();
        int size = response.getSize();
        int rtt = response.getRtt();
        int ttl = response.getTtl();
        return successFlag ? "Reply from " + address + ": bytes=" + size + " time=" + rtt + "ms TTL=" + ttl : "Error: " + message;
    }
}

