/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import org.easymock.ArgumentsMatcher;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.easymock.IMocksControl;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.JavaProxyFactory;
import org.easymock.internal.LastControl;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.MocksBehavior;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.ReplayState;
import org.easymock.internal.RuntimeExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MocksControl
implements IMocksControl {
    private IMocksControlState state;
    private IMocksBehavior behavior;
    private final MockType type;
    public static final Range ONCE = new Range(1);
    public static final Range AT_LEAST_ONCE = new Range(1, Integer.MAX_VALUE);
    public static final Range ZERO_OR_MORE = new Range(0, Integer.MAX_VALUE);

    public MocksControl(MockType type) {
        this.type = type;
        this.reset();
    }

    public IMocksControlState getState() {
        return this.state;
    }

    @Override
    public <T> T createMock(Class<T> toMock) {
        try {
            this.state.assertRecordState();
            IProxyFactory<T> proxyFactory = this.createProxyFactory(toMock);
            return proxyFactory.createProxy(toMock, new ObjectMethodsFilter(toMock, new MockInvocationHandler(this), null));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public <T> T createMock(String name, Class<T> toMock) {
        try {
            this.state.assertRecordState();
            IProxyFactory<T> proxyFactory = this.createProxyFactory(toMock);
            return proxyFactory.createProxy(toMock, new ObjectMethodsFilter(toMock, new MockInvocationHandler(this), name));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    protected <T> IProxyFactory<T> createProxyFactory(Class<T> toMock) {
        return new JavaProxyFactory();
    }

    @Override
    public final void reset() {
        this.behavior = new MocksBehavior(this.type == MockType.NICE);
        this.behavior.checkOrder(this.type == MockType.STRICT);
        this.state = new RecordState(this.behavior);
        LastControl.reportLastControl(null);
    }

    @Override
    public void replay() {
        try {
            this.state.replay();
            this.state = new ReplayState(this.behavior);
            LastControl.reportLastControl(null);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void verify() {
        try {
            this.state.verify();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper e) {
            throw (AssertionError)((Object)((Throwable)((Object)e.getAssertionError())).fillInStackTrace());
        }
    }

    @Override
    public void checkOrder(boolean value) {
        try {
            this.state.checkOrder(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters andReturn(Object value) {
        try {
            this.state.andReturn(value);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters andThrow(Throwable throwable) {
        try {
            this.state.andThrow(throwable);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters andAnswer(IAnswer answer) {
        try {
            this.state.andAnswer(answer);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubReturn(Object value) {
        try {
            this.state.andStubReturn(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        try {
            this.state.andStubThrow(throwable);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void andStubAnswer(IAnswer answer) {
        try {
            this.state.andStubAnswer(answer);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void asStub() {
        try {
            this.state.asStub();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters times(int times) {
        try {
            this.state.times(new Range(times));
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters times(int min2, int max) {
        try {
            this.state.times(new Range(min2, max));
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters once() {
        try {
            this.state.times(ONCE);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters atLeastOnce() {
        try {
            this.state.times(AT_LEAST_ONCE);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public IExpectationSetters anyTimes() {
        try {
            this.state.times(ZERO_OR_MORE);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setLegacyDefaultMatcher(ArgumentsMatcher matcher) {
        try {
            this.state.setDefaultMatcher(matcher);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setLegacyMatcher(ArgumentsMatcher matcher) {
        try {
            this.state.setMatcher(null, matcher);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setLegacyDefaultReturnValue(Object value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setLegacyDefaultVoidCallable() {
        this.state.setDefaultVoidCallable();
    }

    public void setLegacyDefaultThrowable(Throwable throwable) {
        try {
            this.state.setDefaultThrowable(throwable);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MockType {
        NICE,
        DEFAULT,
        STRICT;

    }
}

