/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp.extensions;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.sshd.common.subsystem.sftp.extensions.AbstractParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;

public class VersionsParser
extends AbstractParser<Versions> {
    public static final VersionsParser INSTANCE = new VersionsParser();

    public VersionsParser() {
        super("versions");
    }

    @Override
    public Versions parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public Versions parse(String value) {
        String[] comps = GenericUtils.split(value, ',');
        return new Versions(GenericUtils.isEmpty(comps) ? Collections.emptyList() : Arrays.asList(comps));
    }

    public static class Versions {
        public static final char SEP = ',';
        private List<String> versions;

        public Versions() {
            this(null);
        }

        public Versions(List<String> versions) {
            this.versions = versions;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public void setVersions(List<String> versions) {
            this.versions = versions;
        }

        public List<Integer> resolveAvailableVersions(int current) {
            ArrayList<Integer> currentlyAvailable = Collections.singletonList(current);
            List<String> reported = this.getVersions();
            if (GenericUtils.isEmpty(reported)) {
                return currentlyAvailable;
            }
            NavigableSet<Integer> available = GenericUtils.asSortedSet(currentlyAvailable);
            for (String v : reported) {
                if (NumberUtils.isIntegerNumber(v) && available.add(Integer.valueOf(v))) continue;
            }
            return available.size() == 1 ? currentlyAvailable : new ArrayList<Integer>(available);
        }

        public String toString() {
            return GenericUtils.join(this.getVersions(), ',');
        }
    }
}

