/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.apache.mina.core.polling.AbstractPollingIoAcceptor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioSocketAcceptor
extends AbstractPollingIoAcceptor<NioSession, ServerSocketChannel>
implements SocketAcceptor {
    private int backlog = 50;
    private boolean reuseAddress = false;
    private volatile Selector selector;

    public NioSocketAcceptor() {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), NioProcessor.class);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init(this);
    }

    public NioSocketAcceptor(int processorCount) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), NioProcessor.class, processorCount);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init(this);
    }

    public NioSocketAcceptor(IoProcessor<NioSession> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), processor);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init(this);
    }

    public NioSocketAcceptor(Executor executor, IoProcessor<NioSession> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), executor, processor);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init(this);
    }

    @Override
    protected void init() throws Exception {
        this.selector = Selector.open();
    }

    @Override
    protected void destroy() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioSocketSession.METADATA;
    }

    @Override
    public SocketSessionConfig getSessionConfig() {
        return (SocketSessionConfig)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)super.getLocalAddress();
    }

    @Override
    public InetSocketAddress getDefaultLocalAddress() {
        return (InetSocketAddress)super.getDefaultLocalAddress();
    }

    @Override
    public void setDefaultLocalAddress(InetSocketAddress localAddress) {
        this.setDefaultLocalAddress((SocketAddress)localAddress);
    }

    @Override
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReuseAddress(boolean reuseAddress) {
        Object object = this.bindLock;
        synchronized (object) {
            if (this.isActive()) {
                throw new IllegalStateException("reuseAddress can't be set while the acceptor is bound.");
            }
            this.reuseAddress = reuseAddress;
        }
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBacklog(int backlog) {
        Object object = this.bindLock;
        synchronized (object) {
            if (this.isActive()) {
                throw new IllegalStateException("backlog can't be set while the acceptor is bound.");
            }
            this.backlog = backlog;
        }
    }

    @Override
    protected NioSession accept(IoProcessor<NioSession> processor, ServerSocketChannel handle) throws Exception {
        SelectionKey key = handle.keyFor(this.selector);
        if (!key.isAcceptable()) {
            return null;
        }
        SocketChannel ch = handle.accept();
        if (ch == null) {
            return null;
        }
        return new NioSocketSession(this, processor, ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServerSocketChannel open(SocketAddress localAddress) throws Exception {
        ServerSocketChannel c = ServerSocketChannel.open();
        boolean success = false;
        try {
            c.configureBlocking(false);
            c.socket().setReuseAddress(this.isReuseAddress());
            c.socket().setReceiveBufferSize(this.getSessionConfig().getReceiveBufferSize());
            c.socket().bind(localAddress, this.getBacklog());
            c.register(this.selector, 16);
            success = true;
        }
        finally {
            if (!success) {
                this.close(c);
            }
        }
        return c;
    }

    @Override
    protected SocketAddress localAddress(ServerSocketChannel handle) throws Exception {
        return handle.socket().getLocalSocketAddress();
    }

    @Override
    protected boolean select() throws Exception {
        return this.selector.select() > 0;
    }

    @Override
    protected Iterator<ServerSocketChannel> selectedHandles() {
        return new ServerSocketChannelIterator(this.selector.selectedKeys());
    }

    @Override
    protected void close(ServerSocketChannel handle) throws Exception {
        SelectionKey key = handle.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
        handle.close();
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerSocketChannelIterator
    implements Iterator<ServerSocketChannel> {
        private final Iterator<SelectionKey> i;

        private ServerSocketChannelIterator(Collection<SelectionKey> selectedKeys) {
            this.i = selectedKeys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public ServerSocketChannel next() {
            SelectionKey key = this.i.next();
            return (ServerSocketChannel)key.channel();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

