/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;
import org.apache.mina.transport.socket.DefaultDatagramSessionConfig;

class NioDatagramSessionConfig
extends AbstractDatagramSessionConfig {
    private final DatagramChannel c;

    NioDatagramSessionConfig(DatagramChannel c) {
        this.c = c;
    }

    public int getReceiveBufferSize() {
        try {
            return this.c.socket().getReceiveBufferSize();
        }
        catch (SocketException e) {
            throw new RuntimeIoException(e);
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (DefaultDatagramSessionConfig.isSetReceiveBufferSizeAvailable()) {
            try {
                this.c.socket().setReceiveBufferSize(receiveBufferSize);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }
    }

    public boolean isBroadcast() {
        try {
            return this.c.socket().getBroadcast();
        }
        catch (SocketException e) {
            throw new RuntimeIoException(e);
        }
    }

    public void setBroadcast(boolean broadcast) {
        try {
            this.c.socket().setBroadcast(broadcast);
        }
        catch (SocketException e) {
            throw new RuntimeIoException(e);
        }
    }

    public int getSendBufferSize() {
        try {
            return this.c.socket().getSendBufferSize();
        }
        catch (SocketException e) {
            throw new RuntimeIoException(e);
        }
    }

    public void setSendBufferSize(int sendBufferSize) {
        if (DefaultDatagramSessionConfig.isSetSendBufferSizeAvailable()) {
            try {
                this.c.socket().setSendBufferSize(sendBufferSize);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }
    }

    public boolean isReuseAddress() {
        try {
            return this.c.socket().getReuseAddress();
        }
        catch (SocketException e) {
            throw new RuntimeIoException(e);
        }
    }

    public void setReuseAddress(boolean reuseAddress) {
        try {
            this.c.socket().setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            throw new RuntimeIoException(e);
        }
    }

    public int getTrafficClass() {
        if (DefaultDatagramSessionConfig.isGetTrafficClassAvailable()) {
            try {
                return this.c.socket().getTrafficClass();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }
        return 0;
    }

    public void setTrafficClass(int trafficClass) {
        if (DefaultDatagramSessionConfig.isSetTrafficClassAvailable()) {
            try {
                this.c.socket().setTrafficClass(trafficClass);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }
    }
}

