/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket;

import java.net.DatagramSocket;
import java.net.SocketException;
import org.apache.mina.core.ExceptionMonitor;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;

public class DefaultDatagramSessionConfig
extends AbstractDatagramSessionConfig {
    private static boolean SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
    private static boolean SET_SEND_BUFFER_SIZE_AVAILABLE = false;
    private static boolean GET_TRAFFIC_CLASS_AVAILABLE = false;
    private static final boolean SET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean DEFAULT_BROADCAST = false;
    private static boolean DEFAULT_REUSE_ADDRESS = false;
    private static int DEFAULT_RECEIVE_BUFFER_SIZE = 1024;
    private static int DEFAULT_SEND_BUFFER_SIZE = 1024;
    private static int DEFAULT_TRAFFIC_CLASS = 0;
    private boolean broadcast = DEFAULT_BROADCAST;
    private boolean reuseAddress = DEFAULT_REUSE_ADDRESS;
    private int receiveBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
    private int sendBufferSize = DEFAULT_SEND_BUFFER_SIZE;
    private int trafficClass = DEFAULT_TRAFFIC_CLASS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            DEFAULT_BROADCAST = socket.getBroadcast();
            DEFAULT_REUSE_ADDRESS = socket.getReuseAddress();
            DEFAULT_RECEIVE_BUFFER_SIZE = socket.getReceiveBufferSize();
            DEFAULT_SEND_BUFFER_SIZE = socket.getSendBufferSize();
            try {
                socket.setReceiveBufferSize(DEFAULT_RECEIVE_BUFFER_SIZE);
                SET_RECEIVE_BUFFER_SIZE_AVAILABLE = true;
            }
            catch (SocketException e) {
                SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
            }
            try {
                socket.setSendBufferSize(DEFAULT_SEND_BUFFER_SIZE);
                SET_SEND_BUFFER_SIZE_AVAILABLE = true;
            }
            catch (SocketException e) {
                SET_SEND_BUFFER_SIZE_AVAILABLE = false;
            }
            try {
                DEFAULT_TRAFFIC_CLASS = socket.getTrafficClass();
                GET_TRAFFIC_CLASS_AVAILABLE = true;
            }
            catch (SocketException e) {
                GET_TRAFFIC_CLASS_AVAILABLE = false;
                DEFAULT_TRAFFIC_CLASS = 0;
            }
        }
        catch (SocketException e) {
            ExceptionMonitor.getInstance().exceptionCaught(e);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static boolean isSetReceiveBufferSizeAvailable() {
        return SET_RECEIVE_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isSetSendBufferSizeAvailable() {
        return SET_SEND_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isGetTrafficClassAvailable() {
        return GET_TRAFFIC_CLASS_AVAILABLE;
    }

    public static boolean isSetTrafficClassAvailable() {
        return false;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    protected boolean isBroadcastChanged() {
        return this.broadcast != DEFAULT_BROADCAST;
    }

    protected boolean isReceiveBufferSizeChanged() {
        return this.receiveBufferSize != DEFAULT_RECEIVE_BUFFER_SIZE;
    }

    protected boolean isReuseAddressChanged() {
        return this.reuseAddress != DEFAULT_REUSE_ADDRESS;
    }

    protected boolean isSendBufferSizeChanged() {
        return this.sendBufferSize != DEFAULT_SEND_BUFFER_SIZE;
    }

    protected boolean isTrafficClassChanged() {
        return this.trafficClass != DEFAULT_TRAFFIC_CLASS;
    }

    static {
        DefaultDatagramSessionConfig.initialize();
    }
}

