/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.ssl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterEvent;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.util.CircularQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SslFilter parent;
    private final SSLContext ctx;
    private final IoSession session;
    private final Queue<IoFilterEvent> preHandshakeEventQueue = new CircularQueue<IoFilterEvent>();
    private final Queue<IoFilterEvent> filterWriteEventQueue = new ConcurrentLinkedQueue<IoFilterEvent>();
    private final Queue<IoFilterEvent> messageReceivedEventQueue = new ConcurrentLinkedQueue<IoFilterEvent>();
    private SSLEngine sslEngine;
    private IoBuffer inNetBuffer;
    private IoBuffer outNetBuffer;
    private IoBuffer appBuffer;
    private final IoBuffer emptyBuffer = IoBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean handshakeComplete;
    private boolean writingEncryptedData;

    public SslHandler(SslFilter parent, SSLContext sslc, IoSession session) throws SSLException {
        this.parent = parent;
        this.session = session;
        this.ctx = sslc;
        this.init();
    }

    public void init() throws SSLException {
        if (this.sslEngine != null) {
            return;
        }
        InetSocketAddress peer = (InetSocketAddress)this.session.getAttribute(SslFilter.PEER_ADDRESS);
        this.sslEngine = peer == null ? this.ctx.createSSLEngine() : this.ctx.createSSLEngine(peer.getHostName(), peer.getPort());
        this.sslEngine.setUseClientMode(this.parent.isUseClientMode());
        if (this.parent.isWantClientAuth()) {
            this.sslEngine.setWantClientAuth(true);
        }
        if (this.parent.isNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        }
        if (this.parent.getEnabledCipherSuites() != null) {
            this.sslEngine.setEnabledCipherSuites(this.parent.getEnabledCipherSuites());
        }
        if (this.parent.getEnabledProtocols() != null) {
            this.sslEngine.setEnabledProtocols(this.parent.getEnabledProtocols());
        }
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.handshakeComplete = false;
        this.initialHandshakeComplete = false;
        this.writingEncryptedData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.sslEngine == null) {
            return;
        }
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException e) {
            this.logger.debug("Unexpected exception from SSLEngine.closeInbound().", e);
        }
        if (this.outNetBuffer != null) {
            this.outNetBuffer.capacity(this.sslEngine.getSession().getPacketBufferSize());
        } else {
            this.createOutNetBuffer(0);
        }
        try {
            do {
                this.outNetBuffer.clear();
            } while (this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf()).bytesProduced() > 0);
        }
        catch (SSLException sSLException) {
        }
        finally {
            this.destroyOutNetBuffer();
        }
        this.sslEngine.closeOutbound();
        this.sslEngine = null;
        this.preHandshakeEventQueue.clear();
    }

    private void destroyOutNetBuffer() {
        this.outNetBuffer.free();
        this.outNetBuffer = null;
    }

    public SslFilter getParent() {
        return this.parent;
    }

    public IoSession getSession() {
        return this.session;
    }

    public boolean isWritingEncryptedData() {
        return this.writingEncryptedData;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isInboundDone() {
        return this.sslEngine == null || this.sslEngine.isInboundDone();
    }

    public boolean isOutboundDone() {
        return this.sslEngine == null || this.sslEngine.isOutboundDone();
    }

    public boolean needToCompleteHandshake() {
        return this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    public void schedulePreHandshakeWriteRequest(IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        this.preHandshakeEventQueue.add(new IoFilterEvent(nextFilter, IoEventType.WRITE, this.session, writeRequest));
    }

    public void flushPreHandshakeEvents() throws SSLException {
        IoFilterEvent scheduledWrite;
        while ((scheduledWrite = this.preHandshakeEventQueue.poll()) != null) {
            this.parent.filterWrite(scheduledWrite.getNextFilter(), this.session, (WriteRequest)scheduledWrite.getParameter());
        }
    }

    public void scheduleFilterWrite(IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        this.filterWriteEventQueue.add(new IoFilterEvent(nextFilter, IoEventType.WRITE, this.session, writeRequest));
    }

    public void scheduleMessageReceived(IoFilter.NextFilter nextFilter, Object message) {
        this.messageReceivedEventQueue.add(new IoFilterEvent(nextFilter, IoEventType.MESSAGE_RECEIVED, this.session, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushScheduledEvents() {
        IoFilterEvent e;
        if (Thread.holdsLock(this)) {
            return;
        }
        SslHandler sslHandler = this;
        synchronized (sslHandler) {
            while ((e = this.filterWriteEventQueue.poll()) != null) {
                e.getNextFilter().filterWrite(this.session, (WriteRequest)e.getParameter());
            }
        }
        while ((e = this.messageReceivedEventQueue.poll()) != null) {
            e.getNextFilter().messageReceived(this.session, e.getParameter());
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, ByteBuffer buf) throws SSLException {
        if (this.inNetBuffer == null) {
            this.inNetBuffer = IoBuffer.allocate(buf.remaining()).setAutoExpand(true);
        }
        this.inNetBuffer.put(buf);
        if (!this.handshakeComplete) {
            this.handshake(nextFilter);
        } else {
            this.decrypt(nextFilter);
        }
        if (this.isInboundDone()) {
            int inNetBufferPosition = this.inNetBuffer == null ? 0 : this.inNetBuffer.position();
            buf.position(buf.position() - inNetBufferPosition);
            this.inNetBuffer = null;
        }
    }

    public IoBuffer fetchAppBuffer() {
        IoBuffer appBuffer = this.appBuffer.flip();
        this.appBuffer = null;
        return appBuffer;
    }

    public IoBuffer fetchOutNetBuffer() {
        IoBuffer answer = this.outNetBuffer;
        if (answer == null) {
            return this.emptyBuffer;
        }
        this.outNetBuffer = null;
        return answer.shrink();
    }

    public void encrypt(ByteBuffer src) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        if (!src.hasRemaining()) {
            if (this.outNetBuffer == null) {
                this.outNetBuffer = this.emptyBuffer;
            }
            return;
        }
        this.createOutNetBuffer(src.remaining());
        while (src.hasRemaining()) {
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer.buf());
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1);
                this.outNetBuffer.limit(this.outNetBuffer.capacity());
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)result.getStatus()) + " src: " + src + "outNetBuffer: " + this.outNetBuffer);
        }
        this.outNetBuffer.flip();
    }

    public boolean closeOutbound() throws SSLException {
        SSLEngineResult result;
        if (this.sslEngine == null || this.sslEngine.isOutboundDone()) {
            return false;
        }
        this.sslEngine.closeOutbound();
        this.createOutNetBuffer(0);
        while ((result = this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf())).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1);
            this.outNetBuffer.limit(this.outNetBuffer.capacity());
        }
        if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + result);
        }
        this.outNetBuffer.flip();
        return true;
    }

    private void decrypt(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        this.unwrap(nextFilter);
    }

    private void checkStatus(SSLEngineResult res) throws SSLException {
        SSLEngineResult.Status status = res.getStatus();
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
    }

    public void handshake(IoFilter.NextFilter nextFilter) throws SSLException {
        block9: {
            while (true) {
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.session.setAttribute(SslFilter.SSL_SESSION, this.sslEngine.getSession());
                    this.handshakeComplete = true;
                    if (!this.initialHandshakeComplete && this.session.containsAttribute(SslFilter.USE_NOTIFICATION)) {
                        this.initialHandshakeComplete = true;
                        this.scheduleMessageReceived(nextFilter, SslFilter.SESSION_SECURED);
                    }
                } else {
                    if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.handshakeStatus = this.doTasks();
                        continue;
                    }
                    if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        SSLEngineResult.Status status = this.unwrapHandshake(nextFilter);
                        if ((status != SSLEngineResult.Status.BUFFER_UNDERFLOW || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) && !this.isInboundDone()) continue;
                    } else {
                        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                        if (this.outNetBuffer == null || !this.outNetBuffer.hasRemaining()) {
                            SSLEngineResult result;
                            this.createOutNetBuffer(0);
                            while ((result = this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf())).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1);
                                this.outNetBuffer.limit(this.outNetBuffer.capacity());
                            }
                            this.outNetBuffer.flip();
                            this.handshakeStatus = result.getHandshakeStatus();
                            this.writeNetBuffer(nextFilter);
                            continue;
                        }
                    }
                }
                break block9;
                break;
            }
            throw new IllegalStateException("Invalid Handshaking State" + (Object)((Object)this.handshakeStatus));
        }
    }

    private void createOutNetBuffer(int expectedRemaining) {
        int capacity = Math.max(expectedRemaining, this.sslEngine.getSession().getPacketBufferSize());
        if (this.outNetBuffer != null) {
            this.outNetBuffer.capacity(capacity);
        } else {
            this.outNetBuffer = IoBuffer.allocate(capacity).minimumCapacity(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writeNetBuffer(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.outNetBuffer == null || !this.outNetBuffer.hasRemaining()) {
            return null;
        }
        this.writingEncryptedData = true;
        DefaultWriteFuture writeFuture = null;
        try {
            IoBuffer writeBuffer = this.fetchOutNetBuffer();
            writeFuture = new DefaultWriteFuture(this.session);
            this.parent.filterWrite(nextFilter, this.session, new DefaultWriteRequest(writeBuffer, writeFuture));
            while (this.needToCompleteHandshake()) {
                try {
                    this.handshake(nextFilter);
                }
                catch (SSLException ssle) {
                    SSLHandshakeException newSsle = new SSLHandshakeException("SSL handshake failed.");
                    newSsle.initCause(ssle);
                    throw newSsle;
                }
                IoBuffer outNetBuffer = this.fetchOutNetBuffer();
                if (outNetBuffer == null || !outNetBuffer.hasRemaining()) continue;
                writeFuture = new DefaultWriteFuture(this.session);
                this.parent.filterWrite(nextFilter, this.session, new DefaultWriteRequest(outNetBuffer, writeFuture));
            }
        }
        finally {
            this.writingEncryptedData = false;
        }
        return writeFuture;
    }

    private void unwrap(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.inNetBuffer != null) {
            this.inNetBuffer.flip();
        }
        if (this.inNetBuffer == null || !this.inNetBuffer.hasRemaining()) {
            return;
        }
        SSLEngineResult res = this.unwrap0();
        if (this.inNetBuffer.hasRemaining()) {
            this.inNetBuffer.compact();
        } else {
            this.inNetBuffer = null;
        }
        this.checkStatus(res);
        this.renegotiateIfNeeded(nextFilter, res);
    }

    private SSLEngineResult.Status unwrapHandshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.inNetBuffer != null) {
            this.inNetBuffer.flip();
        }
        if (this.inNetBuffer == null || !this.inNetBuffer.hasRemaining()) {
            return SSLEngineResult.Status.BUFFER_UNDERFLOW;
        }
        SSLEngineResult res = this.unwrap0();
        this.handshakeStatus = res.getHandshakeStatus();
        this.checkStatus(res);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            res = this.unwrap0();
            if (this.inNetBuffer.hasRemaining()) {
                this.inNetBuffer.compact();
            } else {
                this.inNetBuffer = null;
            }
            this.renegotiateIfNeeded(nextFilter, res);
        } else if (this.inNetBuffer.hasRemaining()) {
            this.inNetBuffer.compact();
        } else {
            this.inNetBuffer = null;
        }
        return res.getStatus();
    }

    private void renegotiateIfNeeded(IoFilter.NextFilter nextFilter, SSLEngineResult res) throws SSLException {
        if (res.getStatus() != SSLEngineResult.Status.CLOSED && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshakeComplete = false;
            this.handshakeStatus = res.getHandshakeStatus();
            this.handshake(nextFilter);
        }
    }

    private SSLEngineResult unwrap0() throws SSLException {
        SSLEngineResult res;
        if (this.appBuffer == null) {
            this.appBuffer = IoBuffer.allocate(this.inNetBuffer.remaining());
        } else {
            this.appBuffer.expand(this.inNetBuffer.remaining());
        }
        do {
            if ((res = this.sslEngine.unwrap(this.inNetBuffer.buf(), this.appBuffer.buf())).getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.appBuffer.capacity(this.appBuffer.capacity() << 1);
            this.appBuffer.limit(this.appBuffer.capacity());
        } while ((res.getStatus() == SSLEngineResult.Status.OK || res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) && (this.handshakeComplete && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return res;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public static IoBuffer copy(ByteBuffer src) {
        IoBuffer copy = IoBuffer.allocate(src.remaining());
        copy.put(src);
        copy.flip();
        return copy;
    }
}

