/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.ExceptionMonitor;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.DefaultFileRegion;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.DefaultCloseFuture;
import org.apache.mina.core.future.DefaultReadFuture;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.ReadFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionAttributeMap;
import org.apache.mina.core.session.TrafficMask;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.apache.mina.util.CircularQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoSession
implements IoSession {
    private static final AttributeKey READY_READ_FUTURES_KEY = new AttributeKey(AbstractIoSession.class, "readyReadFutures");
    private static final AttributeKey WAITING_READ_FUTURES_KEY = new AttributeKey(AbstractIoSession.class, "waitingReadFutures");
    private static final IoFutureListener<CloseFuture> SCHEDULED_COUNTER_RESETTER = new IoFutureListener<CloseFuture>(){

        @Override
        public void operationComplete(CloseFuture future) {
            AbstractIoSession s2 = (AbstractIoSession)future.getSession();
            s2.scheduledWriteBytes.set(0);
            s2.scheduledWriteMessages.set(0);
            s2.readBytesThroughput = 0.0;
            s2.readMessagesThroughput = 0.0;
            s2.writtenBytesThroughput = 0.0;
            s2.writtenMessagesThroughput = 0.0;
        }
    };
    private static final WriteRequest CLOSE_REQUEST = new DefaultWriteRequest(new Object());
    private final Object lock = new Object();
    private IoSessionAttributeMap attributes;
    private WriteRequestQueue writeRequestQueue;
    private WriteRequest currentWriteRequest;
    private final long creationTime;
    private final CloseFuture closeFuture = new DefaultCloseFuture(this);
    private volatile boolean closing;
    private volatile TrafficMask trafficMask = TrafficMask.ALL;
    private final AtomicBoolean scheduledForFlush = new AtomicBoolean();
    private final AtomicInteger scheduledWriteBytes = new AtomicInteger();
    private final AtomicInteger scheduledWriteMessages = new AtomicInteger();
    private long readBytes;
    private long writtenBytes;
    private long readMessages;
    private long writtenMessages;
    private long lastReadTime;
    private long lastWriteTime;
    private long lastThroughputCalculationTime;
    private long lastReadBytes;
    private long lastWrittenBytes;
    private long lastReadMessages;
    private long lastWrittenMessages;
    private double readBytesThroughput;
    private double writtenBytesThroughput;
    private double readMessagesThroughput;
    private double writtenMessagesThroughput;
    private int idleCountForBoth;
    private int idleCountForRead;
    private int idleCountForWrite;
    private long lastIdleTimeForBoth;
    private long lastIdleTimeForRead;
    private long lastIdleTimeForWrite;
    private boolean deferDecreaseReadBuffer = true;

    protected AbstractIoSession() {
        long currentTime;
        this.creationTime = currentTime = System.currentTimeMillis();
        this.lastThroughputCalculationTime = currentTime;
        this.lastReadTime = currentTime;
        this.lastWriteTime = currentTime;
        this.lastIdleTimeForBoth = currentTime;
        this.lastIdleTimeForRead = currentTime;
        this.lastIdleTimeForWrite = currentTime;
        this.closeFuture.addListener(SCHEDULED_COUNTER_RESETTER);
    }

    @Override
    public final long getId() {
        return (long)this.hashCode() & 0xFFFFFFFFL;
    }

    public abstract IoProcessor getProcessor();

    @Override
    public final boolean isConnected() {
        return !this.closeFuture.isClosed();
    }

    @Override
    public final boolean isClosing() {
        return this.closing || this.closeFuture.isClosed();
    }

    @Override
    public final CloseFuture getCloseFuture() {
        return this.closeFuture;
    }

    public final boolean isScheduledForFlush() {
        return this.scheduledForFlush.get();
    }

    public final boolean setScheduledForFlush(boolean flag) {
        if (flag) {
            return this.scheduledForFlush.compareAndSet(false, true);
        }
        this.scheduledForFlush.set(false);
        return true;
    }

    @Override
    public final CloseFuture close(boolean rightNow) {
        if (rightNow) {
            return this.close();
        }
        return this.closeOnFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseFuture close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosing()) {
                return this.closeFuture;
            }
            this.closing = true;
        }
        this.getFilterChain().fireFilterClose();
        return this.closeFuture;
    }

    @Override
    public final CloseFuture closeOnFlush() {
        this.getWriteRequestQueue().offer(this, CLOSE_REQUEST);
        this.getProcessor().flush(this);
        return this.closeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ReadFuture read() {
        ReadFuture future;
        Queue<ReadFuture> readyReadFutures;
        if (!this.getConfig().isUseReadOperation()) {
            throw new IllegalStateException("useReadOperation is not enabled.");
        }
        Queue<ReadFuture> queue = readyReadFutures = this.getReadyReadFutures();
        synchronized (queue) {
            future = readyReadFutures.poll();
            if (future != null) {
                if (future.isClosed()) {
                    readyReadFutures.offer(future);
                }
            } else {
                future = new DefaultReadFuture(this);
                this.getWaitingReadFutures().offer(future);
            }
        }
        return future;
    }

    public final void offerReadFuture(Object message) {
        this.newReadFuture().setRead(message);
    }

    public final void offerFailedReadFuture(Throwable exception) {
        this.newReadFuture().setException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void offerClosedReadFuture() {
        Queue<ReadFuture> readyReadFutures;
        Queue<ReadFuture> queue = readyReadFutures = this.getReadyReadFutures();
        synchronized (queue) {
            this.newReadFuture().setClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadFuture newReadFuture() {
        ReadFuture future;
        Queue<ReadFuture> readyReadFutures = this.getReadyReadFutures();
        Queue<ReadFuture> waitingReadFutures = this.getWaitingReadFutures();
        Queue<ReadFuture> queue = readyReadFutures;
        synchronized (queue) {
            future = waitingReadFutures.poll();
            if (future == null) {
                future = new DefaultReadFuture(this);
                readyReadFutures.offer(future);
            }
        }
        return future;
    }

    private Queue<ReadFuture> getReadyReadFutures() {
        Queue oldReadyReadFutures;
        Queue readyReadFutures = (CircularQueue)this.getAttribute(READY_READ_FUTURES_KEY);
        if (readyReadFutures == null && (oldReadyReadFutures = (Queue)this.setAttributeIfAbsent(READY_READ_FUTURES_KEY, readyReadFutures = new CircularQueue())) != null) {
            readyReadFutures = oldReadyReadFutures;
        }
        return readyReadFutures;
    }

    private Queue<ReadFuture> getWaitingReadFutures() {
        Queue oldWaitingReadyReadFutures;
        Queue waitingReadyReadFutures = (CircularQueue)this.getAttribute(WAITING_READ_FUTURES_KEY);
        if (waitingReadyReadFutures == null && (oldWaitingReadyReadFutures = (Queue)this.setAttributeIfAbsent(WAITING_READ_FUTURES_KEY, waitingReadyReadFutures = new CircularQueue())) != null) {
            waitingReadyReadFutures = oldWaitingReadyReadFutures;
        }
        return waitingReadyReadFutures;
    }

    @Override
    public final WriteFuture write(Object message) {
        return this.write(message, null);
    }

    @Override
    public final WriteFuture write(Object message, SocketAddress remoteAddress) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (!this.getTransportMetadata().isConnectionless() && remoteAddress != null) {
            throw new UnsupportedOperationException();
        }
        if (this.isClosing() || !this.isConnected()) {
            DefaultWriteFuture future = new DefaultWriteFuture(this);
            DefaultWriteRequest request = new DefaultWriteRequest(message, future, remoteAddress);
            future.setException(new WriteToClosedSessionException(request));
            return future;
        }
        FileChannel openedFileChannel = null;
        try {
            if (message instanceof IoBuffer && !((IoBuffer)message).hasRemaining()) {
                throw new IllegalArgumentException("message is empty. Forgot to call flip()?");
            }
            if (message instanceof FileChannel) {
                FileChannel fileChannel = (FileChannel)message;
                message = new DefaultFileRegion(fileChannel, 0L, fileChannel.size());
            } else if (message instanceof File) {
                File file = (File)message;
                openedFileChannel = new FileInputStream(file).getChannel();
                message = new DefaultFileRegion(openedFileChannel, 0L, openedFileChannel.size());
            }
        }
        catch (IOException e) {
            ExceptionMonitor.getInstance().exceptionCaught(e);
            return DefaultWriteFuture.newNotWrittenFuture(this, e);
        }
        DefaultWriteFuture future = new DefaultWriteFuture(this);
        this.getFilterChain().fireFilterWrite(new DefaultWriteRequest(message, future, remoteAddress));
        if (openedFileChannel != null) {
            final FileChannel finalChannel = openedFileChannel;
            future.addListener(new IoFutureListener<WriteFuture>(){

                @Override
                public void operationComplete(WriteFuture future) {
                    try {
                        finalChannel.close();
                    }
                    catch (IOException e) {
                        ExceptionMonitor.getInstance().exceptionCaught(e);
                    }
                }
            });
        }
        return future;
    }

    @Override
    public final Object getAttachment() {
        return this.getAttribute("");
    }

    @Override
    public final Object setAttachment(Object attachment) {
        return this.setAttribute("", attachment);
    }

    @Override
    public final Object getAttribute(Object key) {
        return this.getAttribute(key, null);
    }

    @Override
    public final Object getAttribute(Object key, Object defaultValue) {
        return this.attributes.getAttribute(this, key, defaultValue);
    }

    @Override
    public final Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(this, key, value);
    }

    @Override
    public final Object setAttribute(Object key) {
        return this.setAttribute(key, Boolean.TRUE);
    }

    @Override
    public final Object setAttributeIfAbsent(Object key, Object value) {
        return this.attributes.setAttributeIfAbsent(this, key, value);
    }

    @Override
    public final Object setAttributeIfAbsent(Object key) {
        return this.setAttributeIfAbsent(key, Boolean.TRUE);
    }

    @Override
    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(this, key);
    }

    @Override
    public final boolean removeAttribute(Object key, Object value) {
        return this.attributes.removeAttribute(this, key, value);
    }

    @Override
    public final boolean replaceAttribute(Object key, Object oldValue, Object newValue) {
        return this.attributes.replaceAttribute(this, key, oldValue, newValue);
    }

    @Override
    public final boolean containsAttribute(Object key) {
        return this.attributes.containsAttribute(this, key);
    }

    @Override
    public final Set<Object> getAttributeKeys() {
        return this.attributes.getAttributeKeys(this);
    }

    public final IoSessionAttributeMap getAttributeMap() {
        return this.attributes;
    }

    public final void setAttributeMap(IoSessionAttributeMap attributes) {
        this.attributes = attributes;
    }

    public final void setWriteRequestQueue(WriteRequestQueue writeRequestQueue) {
        this.writeRequestQueue = new CloseRequestAwareWriteRequestQueue(writeRequestQueue);
    }

    @Override
    public final TrafficMask getTrafficMask() {
        return this.trafficMask;
    }

    @Override
    public final void setTrafficMask(TrafficMask trafficMask) {
        if (trafficMask == null) {
            throw new NullPointerException("trafficMask");
        }
        if (this.isClosing() || !this.isConnected()) {
            return;
        }
        this.getFilterChain().fireFilterSetTrafficMask(trafficMask);
    }

    public final void setTrafficMaskNow(TrafficMask trafficMask) {
        this.trafficMask = trafficMask;
    }

    @Override
    public final void suspendRead() {
        this.setTrafficMask(this.getTrafficMask().and(TrafficMask.READ.not()));
    }

    @Override
    public final void suspendWrite() {
        this.setTrafficMask(this.getTrafficMask().and(TrafficMask.WRITE.not()));
    }

    @Override
    public final void resumeRead() {
        this.setTrafficMask(this.getTrafficMask().or(TrafficMask.READ));
    }

    @Override
    public final void resumeWrite() {
        this.setTrafficMask(this.getTrafficMask().or(TrafficMask.WRITE));
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    public final long getReadMessages() {
        return this.readMessages;
    }

    @Override
    public final long getWrittenMessages() {
        return this.writtenMessages;
    }

    @Override
    public final double getReadBytesThroughput() {
        return this.readBytesThroughput;
    }

    @Override
    public final double getWrittenBytesThroughput() {
        return this.writtenBytesThroughput;
    }

    @Override
    public final double getReadMessagesThroughput() {
        return this.readMessagesThroughput;
    }

    @Override
    public final double getWrittenMessagesThroughput() {
        return this.writtenMessagesThroughput;
    }

    public final void updateThroughput(long currentTime, boolean force) {
        int interval = (int)(currentTime - this.lastThroughputCalculationTime);
        long minInterval = this.getConfig().getThroughputCalculationIntervalInMillis();
        if (!(minInterval != 0L && (long)interval >= minInterval || force)) {
            return;
        }
        this.readBytesThroughput = (double)(this.readBytes - this.lastReadBytes) * 1000.0 / (double)interval;
        this.writtenBytesThroughput = (double)(this.writtenBytes - this.lastWrittenBytes) * 1000.0 / (double)interval;
        this.readMessagesThroughput = (double)(this.readMessages - this.lastReadMessages) * 1000.0 / (double)interval;
        this.writtenMessagesThroughput = (double)(this.writtenMessages - this.lastWrittenMessages) * 1000.0 / (double)interval;
        this.lastReadBytes = this.readBytes;
        this.lastWrittenBytes = this.writtenBytes;
        this.lastReadMessages = this.readMessages;
        this.lastWrittenMessages = this.writtenMessages;
        this.lastThroughputCalculationTime = currentTime;
    }

    @Override
    public final long getScheduledWriteBytes() {
        return this.scheduledWriteBytes.get();
    }

    @Override
    public final int getScheduledWriteMessages() {
        return this.scheduledWriteMessages.get();
    }

    protected void setScheduledWriteBytes(int byteCount) {
        this.scheduledWriteBytes.set(byteCount);
    }

    protected void setScheduledWriteMessages(int messages) {
        this.scheduledWriteMessages.set(messages);
    }

    public final void increaseReadBytes(long increment, long currentTime) {
        if (increment <= 0L) {
            return;
        }
        this.readBytes += increment;
        this.lastReadTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForRead = 0;
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).increaseReadBytes(increment, currentTime);
        }
    }

    public final void increaseReadMessages(long currentTime) {
        ++this.readMessages;
        this.lastReadTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForRead = 0;
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).increaseReadMessages(currentTime);
        }
    }

    public final void increaseWrittenBytes(int increment, long currentTime) {
        if (increment <= 0) {
            return;
        }
        this.writtenBytes += (long)increment;
        this.lastWriteTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForWrite = 0;
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).increaseWrittenBytes(increment, currentTime);
        }
        this.increaseScheduledWriteBytes(-increment);
    }

    public final void increaseWrittenMessages(WriteRequest request, long currentTime) {
        IoBuffer b;
        Object message = request.getMessage();
        if (message instanceof IoBuffer && (b = (IoBuffer)message).hasRemaining()) {
            return;
        }
        ++this.writtenMessages;
        this.lastWriteTime = currentTime;
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).increaseWrittenMessages(currentTime);
        }
        this.decreaseScheduledWriteMessages();
    }

    public final void increaseScheduledWriteBytes(int increment) {
        this.scheduledWriteBytes.addAndGet(increment);
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).increaseScheduledWriteBytes(increment);
        }
    }

    public final void increaseScheduledWriteMessages() {
        this.scheduledWriteMessages.incrementAndGet();
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).increaseScheduledWriteMessages();
        }
    }

    private void decreaseScheduledWriteMessages() {
        this.scheduledWriteMessages.decrementAndGet();
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).decreaseScheduledWriteMessages();
        }
    }

    public final void decreaseScheduledBytesAndMessages(WriteRequest request) {
        Object message = request.getMessage();
        if (message instanceof IoBuffer) {
            IoBuffer b = (IoBuffer)message;
            if (b.hasRemaining()) {
                this.increaseScheduledWriteBytes(-((IoBuffer)message).remaining());
            } else {
                this.decreaseScheduledWriteMessages();
            }
        } else {
            this.decreaseScheduledWriteMessages();
        }
    }

    public final WriteRequestQueue getWriteRequestQueue() {
        if (this.writeRequestQueue == null) {
            throw new IllegalStateException();
        }
        return this.writeRequestQueue;
    }

    @Override
    public final WriteRequest getCurrentWriteRequest() {
        return this.currentWriteRequest;
    }

    @Override
    public final Object getCurrentWriteMessage() {
        WriteRequest req = this.getCurrentWriteRequest();
        if (req == null) {
            return null;
        }
        return req.getMessage();
    }

    public final void setCurrentWriteRequest(WriteRequest currentWriteRequest) {
        this.currentWriteRequest = currentWriteRequest;
    }

    public final void increaseReadBufferSize() {
        int newReadBufferSize = this.getConfig().getReadBufferSize() << 1;
        if (newReadBufferSize <= this.getConfig().getMaxReadBufferSize()) {
            this.getConfig().setReadBufferSize(newReadBufferSize);
        } else {
            this.getConfig().setReadBufferSize(this.getConfig().getMaxReadBufferSize());
        }
        this.deferDecreaseReadBuffer = true;
    }

    public final void decreaseReadBufferSize() {
        if (this.deferDecreaseReadBuffer) {
            this.deferDecreaseReadBuffer = false;
            return;
        }
        if (this.getConfig().getReadBufferSize() > this.getConfig().getMinReadBufferSize()) {
            this.getConfig().setReadBufferSize(this.getConfig().getReadBufferSize() >>> 1);
        }
        this.deferDecreaseReadBuffer = true;
    }

    @Override
    public final long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public final long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    @Override
    public final long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public final boolean isIdle(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth > 0;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead > 0;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite > 0;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public final boolean isBothIdle() {
        return this.isIdle(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final boolean isReaderIdle() {
        return this.isIdle(IdleStatus.READER_IDLE);
    }

    @Override
    public final boolean isWriterIdle() {
        return this.isIdle(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final int getIdleCount(IdleStatus status) {
        if (this.getConfig().getIdleTime(status) == 0) {
            if (status == IdleStatus.BOTH_IDLE) {
                this.idleCountForBoth = 0;
            }
            if (status == IdleStatus.READER_IDLE) {
                this.idleCountForRead = 0;
            }
            if (status == IdleStatus.WRITER_IDLE) {
                this.idleCountForWrite = 0;
            }
        }
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public final long getLastIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.lastIdleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.lastIdleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.lastIdleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public final void increaseIdleCount(IdleStatus status, long currentTime) {
        if (status == IdleStatus.BOTH_IDLE) {
            ++this.idleCountForBoth;
            this.lastIdleTimeForBoth = currentTime;
        } else if (status == IdleStatus.READER_IDLE) {
            ++this.idleCountForRead;
            this.lastIdleTimeForRead = currentTime;
        } else if (status == IdleStatus.WRITER_IDLE) {
            ++this.idleCountForWrite;
            this.lastIdleTimeForWrite = currentTime;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }

    @Override
    public final int getBothIdleCount() {
        return this.getIdleCount(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final long getLastBothIdleTime() {
        return this.getLastIdleTime(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final long getLastReaderIdleTime() {
        return this.getLastIdleTime(IdleStatus.READER_IDLE);
    }

    @Override
    public final long getLastWriterIdleTime() {
        return this.getLastIdleTime(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final int getReaderIdleCount() {
        return this.getIdleCount(IdleStatus.READER_IDLE);
    }

    @Override
    public final int getWriterIdleCount() {
        return this.getIdleCount(IdleStatus.WRITER_IDLE);
    }

    @Override
    public SocketAddress getServiceAddress() {
        IoService service = this.getService();
        if (service instanceof IoAcceptor) {
            return ((IoAcceptor)service).getLocalAddress();
        }
        return this.getRemoteAddress();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        if (this.getService() instanceof IoAcceptor) {
            return "(" + this.getIdAsString() + ": " + this.getServiceName() + ", server, " + this.getRemoteAddress() + " => " + this.getLocalAddress() + ')';
        }
        return "(" + this.getIdAsString() + ": " + this.getServiceName() + ", client, " + this.getLocalAddress() + " => " + this.getRemoteAddress() + ')';
    }

    private String getIdAsString() {
        String id = Long.toHexString(this.getId()).toUpperCase();
        while (id.length() < 8) {
            id = '0' + id;
        }
        id = "0x" + id;
        return id;
    }

    private String getServiceName() {
        TransportMetadata tm = this.getTransportMetadata();
        if (tm == null) {
            return "null";
        }
        return tm.getProviderName() + ' ' + tm.getName();
    }

    private class CloseRequestAwareWriteRequestQueue
    implements WriteRequestQueue {
        private final WriteRequestQueue q;

        public CloseRequestAwareWriteRequestQueue(WriteRequestQueue q) {
            this.q = q;
        }

        public synchronized WriteRequest poll(IoSession session) {
            WriteRequest answer = this.q.poll(session);
            if (answer == CLOSE_REQUEST) {
                AbstractIoSession.this.close();
                this.dispose(session);
                answer = null;
            }
            return answer;
        }

        public void offer(IoSession session, WriteRequest e) {
            this.q.offer(session, e);
        }

        public boolean isEmpty(IoSession session) {
            return this.q.isEmpty(session);
        }

        public void clear(IoSession session) {
            this.q.clear(session);
        }

        public void dispose(IoSession session) {
            this.q.dispose(session);
        }
    }
}

