/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.polling;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.mina.core.ExceptionMonitor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.AbstractIoAcceptor;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.ExpiringSessionRecycler;
import org.apache.mina.core.session.IdleStatusChecker;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionRecycler;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingConnectionlessIoAcceptor<T extends AbstractIoSession, H>
extends AbstractIoAcceptor {
    private static final IoSessionRecycler DEFAULT_RECYCLER = new ExpiringSessionRecycler();
    private final Object lock = new Object();
    private final IoProcessor<T> processor = new ConnectionlessAcceptorProcessor();
    private final Queue<AbstractIoAcceptor.AcceptorOperationFuture> registerQueue = new ConcurrentLinkedQueue<AbstractIoAcceptor.AcceptorOperationFuture>();
    private final Queue<AbstractIoAcceptor.AcceptorOperationFuture> cancelQueue = new ConcurrentLinkedQueue<AbstractIoAcceptor.AcceptorOperationFuture>();
    private final Queue<T> flushingSessions = new ConcurrentLinkedQueue<T>();
    private final Map<SocketAddress, H> boundHandles = Collections.synchronizedMap(new HashMap());
    private IoSessionRecycler sessionRecycler = DEFAULT_RECYCLER;
    private final AbstractIoService.ServiceOperationFuture disposalFuture = new AbstractIoService.ServiceOperationFuture();
    private volatile boolean selectable;
    private Worker worker;
    private long lastIdleCheckTime;

    protected AbstractPollingConnectionlessIoAcceptor(IoSessionConfig sessionConfig) {
        this(sessionConfig, null);
    }

    protected AbstractPollingConnectionlessIoAcceptor(IoSessionConfig sessionConfig, Executor executor) {
        super(sessionConfig, executor);
        try {
            this.init();
            this.selectable = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeIoException("Failed to initialize.", e);
        }
        finally {
            if (!this.selectable) {
                try {
                    this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    protected abstract void init() throws Exception;

    protected abstract void destroy() throws Exception;

    protected abstract boolean select(int var1) throws Exception;

    protected abstract void wakeup();

    protected abstract Iterator<H> selectedHandles();

    protected abstract H open(SocketAddress var1) throws Exception;

    protected abstract void close(H var1) throws Exception;

    protected abstract SocketAddress localAddress(H var1) throws Exception;

    protected abstract boolean isReadable(H var1);

    protected abstract boolean isWritable(H var1);

    protected abstract SocketAddress receive(H var1, IoBuffer var2) throws Exception;

    protected abstract int send(T var1, IoBuffer var2, SocketAddress var3) throws Exception;

    protected abstract T newSession(IoProcessor<T> var1, H var2, SocketAddress var3) throws Exception;

    protected abstract void setInterestedInWrite(T var1, boolean var2) throws Exception;

    @Override
    protected IoFuture dispose0() throws Exception {
        this.unbind();
        if (!this.disposalFuture.isDone()) {
            this.startupWorker();
            this.wakeup();
        }
        return this.disposalFuture;
    }

    @Override
    protected final Set<SocketAddress> bind0(List<? extends SocketAddress> localAddresses) throws Exception {
        AbstractIoAcceptor.AcceptorOperationFuture request = new AbstractIoAcceptor.AcceptorOperationFuture(localAddresses);
        this.registerQueue.add(request);
        this.startupWorker();
        this.wakeup();
        request.awaitUninterruptibly();
        if (request.getException() != null) {
            throw request.getException();
        }
        HashSet<SocketAddress> newLocalAddresses = new HashSet<SocketAddress>();
        for (H handle : this.boundHandles.values()) {
            newLocalAddresses.add(this.localAddress(handle));
        }
        return newLocalAddresses;
    }

    @Override
    protected final void unbind0(List<? extends SocketAddress> localAddresses) throws Exception {
        AbstractIoAcceptor.AcceptorOperationFuture request = new AbstractIoAcceptor.AcceptorOperationFuture(localAddresses);
        this.cancelQueue.add(request);
        this.startupWorker();
        this.wakeup();
        request.awaitUninterruptibly();
        if (request.getException() != null) {
            throw request.getException();
        }
    }

    @Override
    public final IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        Object object = this.bindLock;
        synchronized (object) {
            if (!this.isActive()) {
                throw new IllegalStateException("Can't create a session from a unbound service.");
            }
            try {
                return this.newSessionWithoutLock(remoteAddress, localAddress);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to create a session.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoSession newSessionWithoutLock(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        IoSession session;
        IoSessionRecycler sessionRecycler;
        H handle = this.boundHandles.get(localAddress);
        if (handle == null) {
            throw new IllegalArgumentException("Unknown local address: " + localAddress);
        }
        IoSessionRecycler ioSessionRecycler = sessionRecycler = this.getSessionRecycler();
        synchronized (ioSessionRecycler) {
            session = sessionRecycler.recycle(localAddress, remoteAddress);
            if (session != null) {
                return session;
            }
            T newSession = this.newSession(this.processor, handle, remoteAddress);
            this.getSessionRecycler().put((IoSession)newSession);
            session = newSession;
        }
        this.finishSessionInitialization(session, null, null);
        try {
            this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            this.getListeners().fireSessionCreated(session);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
        return session;
    }

    public final IoSessionRecycler getSessionRecycler() {
        return this.sessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSessionRecycler(IoSessionRecycler sessionRecycler) {
        Object object = this.bindLock;
        synchronized (object) {
            if (this.isActive()) {
                throw new IllegalStateException("sessionRecycler can't be set while the acceptor is bound.");
            }
            if (sessionRecycler == null) {
                sessionRecycler = DEFAULT_RECYCLER;
            }
            this.sessionRecycler = sessionRecycler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() {
        if (!this.selectable) {
            this.registerQueue.clear();
            this.cancelQueue.clear();
            this.flushingSessions.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.worker = new Worker();
                this.executeWorker(this.worker);
            }
        }
    }

    private boolean scheduleFlush(T session) {
        if (((AbstractIoSession)session).setScheduledForFlush(true)) {
            this.flushingSessions.add(session);
            return true;
        }
        return false;
    }

    private void processReadySessions(Iterator<H> handles) {
        while (handles.hasNext()) {
            H h2 = handles.next();
            handles.remove();
            try {
                if (this.isReadable(h2)) {
                    this.readHandle(h2);
                }
                if (!this.isWritable(h2)) continue;
                for (IoSession session : this.getManagedSessions().values()) {
                    this.scheduleFlush((AbstractIoSession)session);
                }
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
            }
        }
    }

    private void readHandle(H handle) throws Exception {
        IoBuffer readBuf = IoBuffer.allocate(this.getSessionConfig().getReadBufferSize());
        SocketAddress remoteAddress = this.receive(handle, readBuf);
        if (remoteAddress != null) {
            IoSession session = this.newSessionWithoutLock(remoteAddress, this.localAddress(handle));
            readBuf.flip();
            IoBuffer newBuf = IoBuffer.allocate(readBuf.limit());
            newBuf.put(readBuf);
            newBuf.flip();
            session.getFilterChain().fireMessageReceived(newBuf);
        }
    }

    private void flushSessions(long currentTime) {
        AbstractIoSession session;
        while ((session = (AbstractIoSession)this.flushingSessions.poll()) != null) {
            session.setScheduledForFlush(false);
            try {
                boolean flushedAll = this.flush(session, currentTime);
                if (!flushedAll || session.getWriteRequestQueue().isEmpty(session) || session.isScheduledForFlush()) continue;
                this.scheduleFlush(session);
            }
            catch (Exception e) {
                session.getFilterChain().fireExceptionCaught(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(T session, long currentTime) throws Exception {
        this.setInterestedInWrite(session, false);
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)session).getWriteRequestQueue();
        int maxWrittenBytes = session.getConfig().getMaxReadBufferSize() + (session.getConfig().getMaxReadBufferSize() >>> 1);
        int writtenBytes = 0;
        try {
            while (true) {
                int localWrittenBytes;
                IoBuffer buf;
                WriteRequest req;
                if ((req = ((AbstractIoSession)session).getCurrentWriteRequest()) == null) {
                    req = writeRequestQueue.poll((IoSession)session);
                    if (req == null) {
                        break;
                    }
                    ((AbstractIoSession)session).setCurrentWriteRequest(req);
                }
                if ((buf = (IoBuffer)req.getMessage()).remaining() == 0) {
                    ((AbstractIoSession)session).setCurrentWriteRequest(null);
                    buf.reset();
                    session.getFilterChain().fireMessageSent(req);
                    continue;
                }
                SocketAddress destination = req.getDestination();
                if (destination == null) {
                    destination = session.getRemoteAddress();
                }
                if ((localWrittenBytes = this.send(session, buf, destination)) == 0 || writtenBytes >= maxWrittenBytes) {
                    this.setInterestedInWrite(session, true);
                    boolean bl = false;
                    return bl;
                }
                this.setInterestedInWrite(session, false);
                ((AbstractIoSession)session).setCurrentWriteRequest(null);
                writtenBytes += localWrittenBytes;
                buf.reset();
                session.getFilterChain().fireMessageSent(req);
            }
        }
        finally {
            ((AbstractIoSession)session).increaseWrittenBytes(writtenBytes, currentTime);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerHandles() {
        AbstractIoAcceptor.AcceptorOperationFuture req;
        while ((req = this.registerQueue.poll()) != null) {
            HashMap<SocketAddress, H> newHandles = new HashMap<SocketAddress, H>();
            List<SocketAddress> localAddresses = req.getLocalAddresses();
            try {
                for (SocketAddress a : localAddresses) {
                    Object handle = this.open(a);
                    newHandles.put(this.localAddress(handle), handle);
                }
                this.boundHandles.putAll(newHandles);
                this.getListeners().fireServiceActivated();
                req.setDone();
                int i$ = newHandles.size();
                return i$;
            }
            catch (Exception e) {
                req.setException(e);
            }
            finally {
                if (req.getException() == null) continue;
                for (SocketAddress handle : newHandles.values()) {
                    try {
                        this.close(handle);
                    }
                    catch (Exception e) {
                        ExceptionMonitor.getInstance().exceptionCaught(e);
                    }
                }
                this.wakeup();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unregisterHandles() {
        AbstractIoAcceptor.AcceptorOperationFuture request;
        int nHandles = 0;
        while ((request = this.cancelQueue.poll()) != null) {
            for (SocketAddress a : request.getLocalAddresses()) {
                H handle = this.boundHandles.remove(a);
                if (handle == null) continue;
                try {
                    this.close(handle);
                    this.wakeup();
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    ++nHandles;
                }
            }
            request.setDone();
        }
        return nHandles;
    }

    private void notifyIdleSessions(long currentTime) {
        if (currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            IdleStatusChecker.notifyIdleness(this.getListeners().getManagedSessions().values().iterator(), currentTime);
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int nHandles = 0;
            AbstractPollingConnectionlessIoAcceptor.this.lastIdleCheckTime = System.currentTimeMillis();
            while (AbstractPollingConnectionlessIoAcceptor.this.selectable) {
                try {
                    boolean selected = AbstractPollingConnectionlessIoAcceptor.this.select(1000);
                    nHandles += AbstractPollingConnectionlessIoAcceptor.this.registerHandles();
                    if (selected) {
                        AbstractPollingConnectionlessIoAcceptor.this.processReadySessions(AbstractPollingConnectionlessIoAcceptor.this.selectedHandles());
                    }
                    long currentTime = System.currentTimeMillis();
                    AbstractPollingConnectionlessIoAcceptor.this.flushSessions(currentTime);
                    AbstractPollingConnectionlessIoAcceptor.this.notifyIdleSessions(currentTime);
                    if ((nHandles -= AbstractPollingConnectionlessIoAcceptor.this.unregisterHandles()) != 0) continue;
                    Object object = AbstractPollingConnectionlessIoAcceptor.this.lock;
                    synchronized (object) {
                        if (AbstractPollingConnectionlessIoAcceptor.this.registerQueue.isEmpty() && AbstractPollingConnectionlessIoAcceptor.this.cancelQueue.isEmpty()) {
                            AbstractPollingConnectionlessIoAcceptor.this.worker = null;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (AbstractPollingConnectionlessIoAcceptor.this.selectable && AbstractPollingConnectionlessIoAcceptor.this.isDisposing()) {
                AbstractPollingConnectionlessIoAcceptor.this.selectable = false;
                try {
                    AbstractPollingConnectionlessIoAcceptor.this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    AbstractPollingConnectionlessIoAcceptor.this.disposalFuture.setValue(true);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionlessAcceptorProcessor
    implements IoProcessor<T> {
        private ConnectionlessAcceptorProcessor() {
        }

        @Override
        public void add(T session) {
        }

        @Override
        public void flush(T session) {
            if (AbstractPollingConnectionlessIoAcceptor.this.scheduleFlush(session)) {
                AbstractPollingConnectionlessIoAcceptor.this.wakeup();
            }
        }

        @Override
        public void remove(T session) {
            AbstractPollingConnectionlessIoAcceptor.this.getSessionRecycler().remove((IoSession)session);
            AbstractPollingConnectionlessIoAcceptor.this.getListeners().fireSessionDestroyed((IoSession)session);
        }

        @Override
        public void updateTrafficMask(T session) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public boolean isDisposing() {
            return false;
        }
    }
}

