/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.future;

import java.io.IOException;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.future.DefaultIoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.ReadFuture;
import org.apache.mina.core.session.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReadFuture
extends DefaultIoFuture
implements ReadFuture {
    private static final Object CLOSED = new Object();

    public DefaultReadFuture(IoSession session) {
        super(session);
    }

    @Override
    public Object getMessage() {
        if (this.isReady()) {
            Object v = this.getValue();
            if (v == CLOSED) {
                return null;
            }
            if (v instanceof ExceptionHolder) {
                if ((v = ((ExceptionHolder)v).exception) instanceof RuntimeException) {
                    throw (RuntimeException)v;
                }
                if (v instanceof Error) {
                    throw (Error)v;
                }
                if (v instanceof IOException || v instanceof Exception) {
                    throw new RuntimeIoException((Exception)v);
                }
            }
            return v;
        }
        return null;
    }

    @Override
    public boolean isRead() {
        if (this.isReady()) {
            Object v = this.getValue();
            return v != CLOSED && !(v instanceof ExceptionHolder);
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        if (this.isReady()) {
            return this.getValue() == CLOSED;
        }
        return false;
    }

    @Override
    public Throwable getException() {
        Object v;
        if (this.isReady() && (v = this.getValue()) instanceof ExceptionHolder) {
            return ((ExceptionHolder)v).exception;
        }
        return null;
    }

    @Override
    public void setClosed() {
        this.setValue(CLOSED);
    }

    @Override
    public void setRead(Object message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.setValue(message);
    }

    @Override
    public void setException(Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        this.setValue(new ExceptionHolder(exception));
    }

    @Override
    public ReadFuture await() throws InterruptedException {
        return (ReadFuture)super.await();
    }

    @Override
    public ReadFuture awaitUninterruptibly() {
        return (ReadFuture)super.awaitUninterruptibly();
    }

    @Override
    public ReadFuture addListener(IoFutureListener<?> listener) {
        return (ReadFuture)super.addListener(listener);
    }

    @Override
    public ReadFuture removeListener(IoFutureListener<?> listener) {
        return (ReadFuture)super.removeListener(listener);
    }

    private static class ExceptionHolder {
        private final Throwable exception;

        private ExceptionHolder(Throwable exception) {
            this.exception = exception;
        }
    }
}

