/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptorGenerator;
import net.sf.cglib.reflect.FastClass;

public class MethodProxy {
    private Signature sig;
    private String superName;
    private FastClass f1;
    private FastClass f2;
    private int i1;
    private int i2;

    public static MethodProxy create(ClassLoader loader, Class c1, Class c2, String desc, String name1, String name2) {
        final Signature sig1 = new Signature(name1, desc);
        Signature sig2 = new Signature(name2, desc);
        FastClass f1 = MethodProxy.helper(loader, c1);
        FastClass f2 = MethodProxy.helper(loader, c2);
        int i1 = f1.getIndex(sig1);
        int i2 = f2.getIndex(sig2);
        MethodProxy proxy = i1 < 0 ? new MethodProxy(){

            public Object invoke(Object obj, Object[] args) throws Throwable {
                throw new IllegalArgumentException("Protected method: " + sig1);
            }
        } : new MethodProxy();
        proxy.f1 = f1;
        proxy.f2 = f2;
        proxy.i1 = i1;
        proxy.i2 = i2;
        proxy.sig = sig1;
        proxy.superName = name2;
        return proxy;
    }

    private static FastClass helper(ClassLoader loader, Class type) {
        FastClass.Generator g2 = new FastClass.Generator();
        g2.setType(type);
        g2.setClassLoader(loader);
        AbstractClassGenerator fromEnhancer = AbstractClassGenerator.getCurrent();
        if (fromEnhancer != null) {
            g2.setNamingPolicy(fromEnhancer.getNamingPolicy());
            g2.setStrategy(fromEnhancer.getStrategy());
            g2.setAttemptLoad(fromEnhancer.getAttemptLoad());
        }
        return g2.create();
    }

    private MethodProxy() {
    }

    public Signature getSignature() {
        return this.sig;
    }

    public String getSuperName() {
        return this.superName;
    }

    public int getSuperIndex() {
        return this.i2;
    }

    public static MethodProxy find(Class type, Signature sig) {
        try {
            Method m3 = type.getDeclaredMethod("CGLIB$findMethodProxy", MethodInterceptorGenerator.FIND_PROXY_TYPES);
            return (MethodProxy)m3.invoke(null, sig);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + type + " does not use a MethodInterceptor");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e);
        }
    }

    public Object invoke(Object obj, Object[] args) throws Throwable {
        try {
            return this.f1.invoke(this.i1, obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object invokeSuper(Object obj, Object[] args) throws Throwable {
        try {
            return this.f2.invoke(this.i2, obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

