/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.user;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.system.user.ISystemUser;
import com.gamedash.daemon.system.user.SystemUserException;
import java.io.File;
import org.apache.commons.lang.SystemUtils;

public class SystemUser {
    private final String name;
    private final ISystemUser api;
    private String storedPassword;

    public SystemUser(String name, ISystemUser api) {
        this.name = name;
        this.api = api;
    }

    public String getName() {
        return this.name;
    }

    public void setPassword(String password) throws Exception {
        this.api.setPassword(password);
    }

    public void assignFileSystemFilePermission(File file) throws Exception {
        this.api.assignFileSystemFilePermission(file);
    }

    public void setHomeDirectory(File directory) throws Exception {
        this.api.setHomeDirectory(directory);
    }

    public String getStoredPassword() {
        return this.storedPassword;
    }

    public boolean hasStoredPassword() {
        return this.storedPassword != null;
    }

    public void setStoredPassword(String password) {
        this.storedPassword = password;
    }

    public void delete() throws Exception {
        this.api.delete();
    }

    public String getUuid() throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            ChildProcess process = ChildProcesses.create();
            process.setCanInterrupt(false);
            process.spawn("id -u " + this.getName());
            process.waitForExit();
            if (process.getExitCode() != 0) {
                throw new SystemUserException("Could not fetch user uuid");
            }
            return process.getIo().getOutputItems().get(0).getValue();
        }
        return null;
    }
}

