/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.shutdown;

import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.initialization.InitializerImplementationsRegistry;
import com.gamedash.daemon.common.initialization.implementation.IInitializerImplementation;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.shutdown.ShutdownHooks;
import com.gamedash.daemon.installer.Installer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager
extends com.gamedash.daemon.common.shutdown.ShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownManager.class);

    public static void registerHook() {
        ShutdownHooks.register(new Thread(() -> {
            block2: {
                logger.info("Shutting down");
                try {
                    ShutdownManager.run();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                    if (!DevelopmentMode.isEnabled()) break block2;
                    logger.error(e.getMessage());
                }
            }
        }));
    }

    public static synchronized void run() throws Exception {
        if (ShutdownManager.isShuttingDown()) {
            return;
        }
        ShutdownManager.setIsShuttingDown(true);
        if (Installer.getState() == InstallerStateEnum.inProgress) {
            Installer.setState(InstallerStateEnum.notInstalled);
        }
        ShutdownManager.destroyInitializers();
    }

    private static void destroyInitializers() {
        for (IInitializerImplementation implementation : InitializerImplementationsRegistry.getImplementations()) {
            try {
                if (!implementation.isAvailable()) continue;
                implementation.destroy();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
    }
}

