/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server;

import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.relay.server.RelayServer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RelayServers {
    private static final List<RelayServer> instances = new CopyOnWriteArrayList<RelayServer>();
    private static final CachedValue<String> primary = new CachedValue();

    public static List<RelayServer> getInstances() {
        return instances;
    }

    public static RelayServer getInstanceById(String id) {
        for (RelayServer instance : RelayServers.getInstances()) {
            if (!instance.getId().equals(id)) continue;
            return instance;
        }
        return null;
    }

    public static RelayServer getPrimaryInstance() throws Exception {
        String id = primary.handle(() -> RelayServers.createInstance("primary").getId());
        return RelayServers.getInstanceById(id);
    }

    public static RelayServer createInstance(String id) throws Exception {
        RelayServer instance = new RelayServer(id);
        instances.add(instance);
        return instance;
    }
}

