/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.client.channel;

import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.relay.host.RelayHost;
import com.gamedash.daemon.relay.host.RelayHosts;
import com.gamedash.daemon.relay.message.RelayMessage;
import com.google.gson.Gson;

public class RelayChannel {
    private final String name;

    public RelayChannel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void broadcast(RelayMessage<?> message) throws Exception {
        final RelayHost host = RelayHosts.getPrimary();
        ApiQuery query = new ApiQuery("broadcast"){

            @Override
            public String getAddress() throws Exception {
                return this.getProtocol() + "://" + host.getNetwork().getDomain() + ":" + host.getNetwork().getApiPort() + "/" + this.getEndpoint();
            }

            @Override
            protected Boolean isSecure() {
                return host.getNetwork().apiIsSecure();
            }
        };
        query.getParameters().create("channel", this.getName()).setValue(this.getName());
        query.getParameters().create("type", message.getType()).setValue(message.getType());
        query.getParameters().create("message", new Gson().toJson(message.getMessage()));
        query.post();
    }
}

