/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.io;

import com.gamedash.daemon.common.listener.SimpleListener;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.IOnCloseCallback;
import com.gamedash.daemon.process.childProcess.io.IOnOutputCallback;
import com.gamedash.daemon.process.childProcess.io.Io;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.io.OnOutputListener;
import com.gamedash.daemon.process.childProcess.terminal.io.output.queue.OutputQueueManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIo {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractIo.class);
    private final OutputQueueManager outputQueueManager;
    private final int historySize = Io.getHistorySize();
    private volatile long currentIndex;
    protected OnOutputListener onOutputListener = new OnOutputListener();
    protected SimpleListener onCloseListener = new SimpleListener();
    protected ChildProcess childProcess;
    private boolean hasClosed = false;
    protected BlockingQueue<OutputItem> outputItems = new ArrayBlockingQueue<OutputItem>(this.historySize);

    public AbstractIo(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.outputQueueManager = new OutputQueueManager(childProcess);
    }

    public long getCurrentIndex() {
        return this.currentIndex;
    }

    public synchronized void setCurrentIndex(long index) {
        this.currentIndex = index;
    }

    public synchronized long incrementCurrentIndex() {
        long index = this.getCurrentIndex() + 1L;
        this.setCurrentIndex(index);
        return index;
    }

    public synchronized void addOutputItem(OutputItem outputItem) {
        if (this.outputItems.size() >= this.historySize) {
            this.outputItems.poll();
        }
        long index = this.incrementCurrentIndex();
        outputItem.setIndex(index);
        this.outputItems.add(outputItem);
    }

    public List<OutputItem> getOutputItems() {
        return new ArrayList<OutputItem>(this.outputItems);
    }

    public List<OutputItem> getOutputItems(int tail) {
        ArrayList<OutputItem> output = new ArrayList<OutputItem>(this.outputItems);
        return output.subList(Math.max(output.size() - tail, 0), output.size());
    }

    public void onOutput(IOnOutputCallback callback) {
        this.onOutputListener.addCallback(callback);
    }

    public List<CompletableFuture<Void>> invokeOnOutputListener(OutputItem item) {
        return this.onOutputListener.invokeAsync(item);
    }

    public void onClose(IOnCloseCallback callback) {
        if (this.hasClosed()) {
            callback.invoke();
        }
        this.onCloseListener.addCallback(callback);
    }

    public void waitFor() throws Exception {
        CountDownLatch callbackLatch = new CountDownLatch(1);
        this.onClose(callbackLatch::countDown);
        callbackLatch.await();
    }

    public List<CompletableFuture<Void>> invokeOnCloseListener() {
        return this.onCloseListener.invokeAsync();
    }

    public boolean hasClosed() {
        return this.hasClosed;
    }

    public OutputQueueManager getOutputQueueManager() {
        return this.outputQueueManager;
    }

    protected void setHasClosed(boolean hasClosed) {
        this.hasClosed = hasClosed;
    }
}

