/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.reference;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.reference.ChildProcessReference;
import com.gamedash.daemon.process.childProcess.reference.ChildProcessReferenceAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChildProcessReferences {
    private ChildProcess childProcess;
    private static List<ChildProcessReference> references = new CopyOnWriteArrayList<ChildProcessReference>(new ArrayList());

    public ChildProcessReferences(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public static List<ChildProcessReference> getAll() {
        return references;
    }

    public static void add(ChildProcessReference reference) {
        references.add(reference);
    }

    public static void remove(String name) {
        ListIterator<ChildProcessReference> iterator = ChildProcessReferences.getAll().listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            ChildProcessReference reference = iterator.next();
            if (!reference.getName().equalsIgnoreCase(name)) continue;
            references.remove(index);
        }
    }

    public static boolean exists(String name) {
        for (ChildProcessReference reference : ChildProcessReferences.getAll()) {
            if (!reference.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<ChildProcessReference> getAllLocal() {
        ArrayList<ChildProcessReference> references = new ArrayList<ChildProcessReference>();
        for (ChildProcessReference reference : ChildProcessReferences.getAll()) {
            if (!reference.getChildProcess().getId().equals(this.childProcess.getId())) continue;
            references.add(reference);
        }
        return references;
    }

    public void removeAllLocal() {
        for (ChildProcessReference reference : this.getAllLocal()) {
            ChildProcessReferences.remove(reference.getName());
        }
    }

    public ChildProcessReference createLocal(String name) {
        if (ChildProcessReferences.exists(name)) {
            throw new ChildProcessReferenceAlreadyExistsException("Reference " + name + " already exists");
        }
        ChildProcessReference reference = new ChildProcessReference(this.childProcess, name);
        ChildProcessReferences.add(reference);
        return reference;
    }
}

