/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.io.listener;

import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.message.RelayMessage;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.AbstractIOListener;
import com.gamedash.daemon.process.childProcess.io.relay.RelayOutputItem;
import com.gamedash.daemon.relay.server.RelayServer;
import com.gamedash.daemon.relay.server.RelayServers;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class IORelayListener
extends AbstractIOListener {
    private final List<String> channels;
    private final CachedValue<RelayServer> server = new CachedValue();

    public IORelayListener(ChildProcess childProcess) {
        this(childProcess, new ArrayList<String>());
    }

    public IORelayListener(ChildProcess childProcess, List<String> channels) {
        this.channels = channels;
    }

    @Override
    public void onOutput(OutputItem item) throws Exception {
        RelayOutputItem outputItem = new RelayOutputItem(item);
        outputItem.setSourceName("process");
        for (RelayChannel channel : this.getChannels()) {
            channel.broadcast(new RelayMessage<RelayOutputItem>("childprocess.io.output", outputItem));
        }
    }

    public List<RelayChannel> getChannels() throws Exception {
        RelayServer server = this.getServer();
        return this.channels.stream().map(name -> server.getChannels().acquire((String)name)).collect(Collectors.toList());
    }

    public void addChannel(String name) {
        this.channels.add(name);
    }

    public void addChannel(RelayChannel channel) {
        this.channels.add(channel.getName());
    }

    public RelayServer getServer() throws Exception {
        return this.server.handle(RelayServers::getPrimaryInstance);
    }
}

