/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.io.listener;

import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.IIOListener;
import com.google.common.util.concurrent.RateLimiter;

public class IORateLimitListenerDecorator
implements IIOListener {
    private final IIOListener listener;
    private final RateLimiter rateLimiter = RateLimiter.create(5.0);
    private boolean closed;

    public IORateLimitListenerDecorator(IIOListener listener) {
        this.listener = listener;
    }

    @Override
    public void onOutput(OutputItem item) throws Exception {
        this.rateLimiter.acquire();
        if (!this.isClosed()) {
            this.listener.onOutput(item);
        }
    }

    @Override
    public void onClose() throws Exception {
        this.listener.onClose();
        this.setIsClosed(true);
    }

    public double getRateLimit() {
        return this.rateLimiter.getRate();
    }

    public void setRateLimit(double rateLimit) {
        this.rateLimiter.setRate(rateLimit);
    }

    private boolean isClosed() {
        return this.closed;
    }

    private void setIsClosed(boolean closed) {
        this.closed = closed;
    }
}

