/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.io.listener;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.AbstractIOListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IOFilterListener
extends AbstractIOListener {
    private ChildProcess childProcess;
    private List<String> filters;

    public IOFilterListener(ChildProcess childProcess, List<String> filters) {
        this.childProcess = childProcess;
        this.filters = filters;
    }

    @Override
    public void onOutput(OutputItem item) throws Exception {
        if (item.isError()) {
            return;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String filter : this.filters) {
            Matcher matcher = Pattern.compile(filter).matcher(item.getValue());
            while (matcher.find()) {
                matches.add(matcher.group(1));
            }
        }
        if (matches.size() > 0) {
            ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/process/childprocess/" + this.childProcess.getId() + "/io/output/filtered");
            query.getParameters().create("value", item.getValue());
            query.post();
        }
    }
}

