/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcess;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcessException;

public class WindowsPlatformResourceProcessUsage {
    private WindowsPlatformProcess process;

    public WindowsPlatformResourceProcessUsage(WindowsPlatformProcess process) {
        this.process = process;
    }

    public double getCpuPercentage() throws WindowsPlatformProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessResourceUsageCpuPercentage(this.process.getId()));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsDouble();
    }

    public long getRamMb() throws WindowsPlatformProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessResourceUsageRamMb(this.process.getId()));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsLong();
    }
}

