/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.common.singleton.SingletonList;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcess;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcessException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsPlatformProcesses {
    private static final SingletonList<WindowsPlatformProcess> processes = new SingletonList<WindowsPlatformProcess>(){

        @Override
        public boolean compare(WindowsPlatformProcess a, WindowsPlatformProcess b) {
            return a.getId() == b.getId();
        }
    };

    public static List<WindowsPlatformProcess> getAll() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getAllProcesses());
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsPlatformProcess> processes = new ArrayList<WindowsPlatformProcess>();
        for (JsonElement jsonElement : result.getResultValueAsJson().getAsJsonArray()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            WindowsPlatformProcess process = WindowsPlatformProcesses.get(jsonObject.get("id").getAsInt());
            process.dataLayer.setValue("name", jsonObject.get("name").getAsString());
            process.dataLayer.setValue("fileName", jsonObject.get("fileName").getAsString());
            ArrayList<String> argumentsList = new ArrayList<String>();
            for (JsonElement argumentJsonArrayElement : jsonObject.get("arguments").getAsJsonArray()) {
                argumentsList.add(argumentJsonArrayElement.getAsString());
            }
            process.dataLayer.setValue("arguments", argumentsList.toArray(new String[0]));
            process.dataLayer.setValue("workingDirectory", new File(jsonObject.get("workingDirectory").getAsString()));
            processes.add(process);
        }
        return processes;
    }

    public static WindowsPlatformProcess get(int id) {
        WindowsPlatformProcess process = processes.find(_process -> _process.getId() == id);
        if (process == null) {
            process = new WindowsPlatformProcess(id);
            processes.add(process);
        }
        return process;
    }

    public static boolean exists(int id) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().processExists(id));
        if (result.isError()) {
            throw new WindowsPlatformProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsBoolean();
    }
}

