/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.packageManager.packages.distro;

import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackage;
import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackageException;
import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackageNotFoundException;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.IDistro;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class RHEL
implements IDistro {
    private LinuxPackage linuxPackage;

    public RHEL(LinuxPackage linuxPackage) {
        this.linuxPackage = linuxPackage;
    }

    @Override
    public void install() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("yum", new String[]{"-y", "install", this.linuxPackage.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            if (childProcess.getExitCode() == 100) {
                throw new LinuxPackageNotFoundException("Package " + this.linuxPackage.getName() + " could not be found");
            }
            throw new LinuxPackageException("Could not install package");
        }
    }

    @Override
    public void uninstall() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("yum", new String[]{"-y", "uninstall", this.linuxPackage.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxPackageException("Could not uninstall package");
        }
    }
}

