/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.license.validation;

import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.license.LicenseManager;
import com.gamedash.daemon.license.LicenseValidationResult;
import com.gamedash.daemon.license.validation.LicenseValidationManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicValidationManager {
    private final Logger logger = LoggerFactory.getLogger(PeriodicValidationManager.class);
    private final ScheduledExecutorService schedulerExecutorService = Executors.newScheduledThreadPool(1);
    private Time timeFailed;
    private int timeout = 0;
    private int period = 0;

    public PeriodicValidationManager() {
        this.setPeriod(2);
        this.setTimeout(43200);
    }

    public void start() {
        this.schedulerExecutorService.scheduleAtFixedRate(() -> {
            try {
                LicenseValidationResult result = LicenseManager.validateCurrent();
                if (result.isValid()) {
                    this.clearTimeSinceFail();
                    LicenseValidationManager.invokeOnValidityChange(result);
                } else {
                    Long timeSinceFail = this.getTimeSinceFailed();
                    if (timeSinceFail == null) {
                        this.setTimeFailed(Time.now());
                    } else if (timeSinceFail > (long)this.getTimeout()) {
                        LicenseValidationManager.invokeOnValidityChange(result);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(ExceptionUtils.getStackTrace(e));
            }
        }, this.getPeriod(), this.getPeriod(), TimeUnit.SECONDS);
    }

    public void stop() throws InterruptedException {
        this.schedulerExecutorService.shutdown();
        this.schedulerExecutorService.awaitTermination(16L, TimeUnit.SECONDS);
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Time getTimeFailed() {
        return this.timeFailed;
    }

    public Long getTimeSinceFailed() {
        Time timeFailed = this.getTimeFailed();
        return timeFailed != null ? Long.valueOf(Time.now().getTimestamp() - timeFailed.getTimestamp()) : null;
    }

    public void setTimeFailed(Time time) {
        this.timeFailed = time;
    }

    public void clearTimeSinceFail() {
        this.setTimeFailed(null);
    }
}

