/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.license;

import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.common.license.Licenses;
import com.gamedash.daemon.common.license.current.CurrentLicense;
import com.gamedash.daemon.common.license.domain.LicenseDomains;
import com.gamedash.daemon.common.license.system.LicenseSystemAlreadyExistsException;
import com.gamedash.daemon.common.license.system.LicenseSystemMaxExceededException;
import com.gamedash.daemon.license.InvalidLicenseException;
import com.gamedash.daemon.license.LicenseValidationResult;

public class LicenseManager {
    private static final CachedValue<LicenseValidationResult> valid = new CachedValue();
    private static Boolean lastValidationState;

    public static LicenseValidationResult validateCurrent() throws Exception {
        return valid.handle(() -> {
            LicenseValidationResult result = LicenseManager.fetchCurrentValidationState();
            LicenseManager.setLastValidationState(result.isValid());
            return result;
        });
    }

    public static void ensureCurrentLicenseIsValid() throws Exception {
        LicenseValidationResult result = LicenseManager.validateCurrent();
        if (!result.isValid()) {
            throw new InvalidLicenseException(result.getMessage() != null ? result.getMessage() : "Invalid license");
        }
    }

    private static LicenseValidationResult fetchCurrentValidationState() throws Exception {
        block5: {
            if (!LicenseDomains.exists(ApiClientConfig.getDomain())) {
                return new LicenseValidationResult(false, "License domain " + ApiClientConfig.getDomain() + " could not be found");
            }
            CurrentLicense license = Licenses.getCurrent();
            if (license.syncHasTimedOut()) {
                LicenseValidationResult result = new LicenseValidationResult(false, "License has timed out");
                result.setCode("SYNC_TIMED_OUT");
                return result;
            }
            String id = license.getSystems().getCurrent().getId();
            try {
                Licenses.getCurrent().getSystems().create(id);
            }
            catch (Exception e) {
                if (e instanceof LicenseSystemAlreadyExistsException) break block5;
                if (e instanceof LicenseSystemMaxExceededException) {
                    LicenseValidationResult result = new LicenseValidationResult(false, e.getMessage());
                    result.setCode("SYSTEM_MAX_EXCEEDED");
                    return result;
                }
                return new LicenseValidationResult(false, e.getMessage());
            }
        }
        return new LicenseValidationResult(true);
    }

    public static Boolean getLastValidationState() {
        return lastValidationState;
    }

    public static void setLastValidationState(Boolean valid) {
        lastValidationState = valid;
    }

    static {
        valid.setExpiryThreshold(60);
    }
}

