/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation;

import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import com.gamedash.daemon.system.hardware.processor.governor.ProcessorGovernors;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorGovernorsInitializer
extends InitializerImplementation {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorGovernorsInitializer.class);

    @Override
    public void initialize() throws Exception {
        if (!ProcessorGovernors.isAvailable()) {
            logger.warn("Processor governors are not available");
            return;
        }
        try {
            List<Processor> processors = Processors.getAll();
            for (Processor processor : processors) {
                processor.enforcePerformanceGovernor();
            }
            logger.info("Enforced performance governor for all " + processors.size() + " processors");
        }
        catch (Exception e) {
            logger.error("Could not enforce performance governor for processors " + e.getMessage());
        }
        super.initialize();
    }

    @Override
    public boolean isAvailable() throws Exception {
        return ProcessorGovernors.shouldEnforcePerformanceGovernor();
    }
}

