/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation;

import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistry;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistryEntry;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistryFile;

public class DockerContainersInitializer
extends InitializerImplementation {
    @Override
    public void initialize() throws Exception {
        this.restoreContainers();
    }

    @Override
    public void destroy() throws Exception {
        for (DockerContainer container : Docker.getInstance().getContainers().getAll()) {
            if (!container.getIo().isAttached()) continue;
            container.getIo().destroy();
        }
        super.destroy();
    }

    private void restoreContainers() throws Exception {
        DockerContainerRegistryFile registryFile = DockerContainerRegistry.getDefaultFile();
        if (registryFile == null) {
            return;
        }
        for (DockerContainerRegistryEntry entry : registryFile.getEntries()) {
            System.out.println("Restore " + entry.getId());
            DockerContainer container = Docker.getInstance().getContainers().get(entry.getId());
            container.getIo().ensureIsAttached();
        }
    }
}

