/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation;

import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.Dependency;
import me.tongfei.progressbar.ProgressBar;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesInitializer
extends InitializerImplementation {
    private static final Logger logger = LoggerFactory.getLogger(DependenciesInitializer.class);

    @Override
    public void initialize() throws Exception {
        for (Dependency dependency : Dependencies.getAll()) {
            if (dependency.isInstalled() || !dependency.isAvailable()) continue;
            try (ProgressBar progressBar = new ProgressBar("Installing " + dependency.getName() + "...", 100L);){
                dependency.getInstallManager().onInstallProgress(progress -> {
                    progressBar.stepTo(Double.valueOf(Math.ceil(progress.getPercentage())).longValue());
                    if (progress.getMessage() != null) {
                        progressBar.setExtraMessage(progress.getMessage());
                    }
                });
                dependency.getInstallManager().install();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
        super.initialize();
    }
}

