/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation;

import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.process.childProcess.ChildProcessStore;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessesInitializer
extends InitializerImplementation {
    private static final Logger logger = LoggerFactory.getLogger(ChildProcessesInitializer.class);

    @Override
    public void initialize() {
        logger.info("Using child process store origin " + ChildProcessStore.getOrigin());
    }

    @Override
    public void destroy() throws Exception {
        if (!ChildProcessStore.hasModifiedOrigin()) {
            this.destroyRunningProcesses();
        }
        super.destroy();
    }

    private void destroyRunningProcesses() throws Exception {
        List<ChildProcess> running = ChildProcesses.getRunning();
        if (running.size() > 0) {
            ArrayList<ChildProcess> processesToAwaitExit = new ArrayList<ChildProcess>();
            for (ChildProcess childProcess : running) {
                try {
                    if (childProcess.canInterrupt()) {
                        childProcess.stop();
                        continue;
                    }
                    processesToAwaitExit.add(childProcess);
                }
                catch (ChildProcessNotRunningException childProcessNotRunningException) {
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }
            for (ChildProcess childProcess : processesToAwaitExit) {
                childProcess.waitForExit();
            }
        }
    }
}

