/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.api.client.ApiClientConfigValidationResult;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;

public class ApiClientInitializer
extends InitializerImplementation {
    @Override
    public void initialize() throws Exception {
        ApiClientConfigValidationResult apiClientConfigValidationResult;
        if (!Config.fileExists("daemon.properties")) {
            throw new ConfigException("daemon.properties does not exist");
        }
        if (Application.args.apiClientDomain != null) {
            ApiClientConfig.setDomain(Application.args.apiClientDomain);
        }
        if (Application.args.apiClientVersion != null) {
            ApiClientConfig.setVersion(Application.args.apiClientVersion);
        }
        if (!(apiClientConfigValidationResult = ApiClientConfig.validate()).isValid()) {
            throw new RuntimeException(apiClientConfigValidationResult.getMessage() != null ? apiClientConfigValidationResult.getMessage() : "Invalid API client config");
        }
        super.initialize();
    }
}

