/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.flag;

import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.flag.IFlagProvider;
import java.util.ArrayList;
import java.util.List;

public class Flags {
    private static Time lastFetchTime;
    private static final List<String> flags;
    private static final List<IFlagProvider> providers;

    public static List<String> getAll() {
        return flags;
    }

    public static boolean hasFlags(List<String> flags) {
        for (String flag : flags) {
            if (Flags.getAll().contains(flag)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasFlag(final String flag) {
        return Flags.hasFlags((List<String>)new ArrayList<String>(){
            {
                this.add(flag);
            }
        });
    }

    private static void add(String flag) {
        flags.add(flag);
    }

    private static void addAll(List<String> flags) {
        Flags.flags.addAll(flags);
    }

    public static void fetch() throws Exception {
        for (IFlagProvider provider : Flags.getProviders()) {
            Flags.addAll(provider.fetchFlags());
        }
    }

    public static List<IFlagProvider> getProviders() {
        return providers;
    }

    public static void addProvider(IFlagProvider provider) throws Exception {
        providers.add(provider);
        Flags.addAll(provider.fetchFlags());
    }

    private static void ensureHasFetched() throws Exception {
        if (Flags.getLastFetchTime() == null) {
            Flags.fetch();
        }
    }

    private static Time getLastFetchTime() {
        return lastFetchTime;
    }

    private static void setLastFetchTime(Time time) {
        lastFetchTime = time;
    }

    private static void updateLastFetchTime() {
        Flags.setLastFetchTime(Time.now());
    }

    static {
        flags = new ArrayList<String>();
        providers = new ArrayList<IFlagProvider>();
    }
}

