/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.common.network.Network;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHost;
import com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.SFTPHostImplementation;
import com.google.gson.JsonElement;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class RemoteFileSystemHosts {
    private static final CachedValue<List<RemoteFileSystemHost>> hosts = new CachedValue();
    private static final List<RemoteFileSystemHost> running = new CopyOnWriteArrayList<RemoteFileSystemHost>();
    private static final Map<String, Class<?>> implementations = new HashMap<String, Class<?>>(){
        {
            this.put("SFTP", SFTPHostImplementation.class);
        }
    };

    public static void start() throws Exception {
        for (RemoteFileSystemHost host : RemoteFileSystemHosts.getAll()) {
            if (host.isRunning()) continue;
            host.start();
        }
    }

    public static void stop() throws Exception {
        for (RemoteFileSystemHost host : RemoteFileSystemHosts.getAll()) {
            if (!host.isRunning()) continue;
            host.stop();
        }
    }

    public static List<RemoteFileSystemHost> getRunning() {
        return running;
    }

    public static boolean implementationIsRunning(RemoteFileSystemHost host) {
        for (RemoteFileSystemHost _host : RemoteFileSystemHosts.getRunning()) {
            if (host != _host) continue;
            return true;
        }
        return false;
    }

    public static void addRunning(RemoteFileSystemHost host) {
        running.add(host);
    }

    public static void removeRunning(RemoteFileSystemHost host) {
        running.remove(host);
    }

    public static List<RemoteFileSystemHost> getAll() throws Exception {
        return hosts.handle(() -> {
            ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/remote/host/all");
            QueryResponse queryResponse = query.get();
            ArrayList<RemoteFileSystemHost> hosts = new ArrayList<RemoteFileSystemHost>();
            for (JsonElement element : queryResponse.getJsonObject().get("response").getAsJsonArray()) {
                String implementationName = element.getAsJsonObject().get("implementation").getAsJsonObject().get("name").getAsString();
                Class<?> implementationClass = null;
                if (implementationName.equalsIgnoreCase("SFTP")) {
                    implementationClass = implementations.get("SFTP");
                }
                if (implementationClass == null) continue;
                hosts.add(new RemoteFileSystemHost(implementationClass, !element.getAsJsonObject().get("ip").isJsonNull() ? InetAddress.getByName(element.getAsJsonObject().get("ip").getAsString()) : Network.getIp(), element.getAsJsonObject().get("port").getAsInt(), element.getAsJsonObject().get("isSecure").getAsBoolean()));
            }
            return hosts;
        });
    }
}

