/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.upload.session.chunk;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.fileSystem.FileSystem;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chunk {
    private static Logger logger = LoggerFactory.getLogger(Chunk.class);
    private Session session;
    private long id;
    private boolean hasReceived = false;

    public Chunk(Session session, long id) {
        this.session = session;
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public boolean hasContents() throws Exception {
        return this.getFile().exists();
    }

    public void receive(InputStream inputStream) throws Exception {
        if (!this.getFile().exists()) {
            this.getFile().createNewFile();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.getFile());){
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
        }
        this.setHasReceived(true);
    }

    public BufferedInputStream getStream() throws Exception {
        return new BufferedInputStream(new FileInputStream(this.getFile()));
    }

    public boolean isLast() {
        return this.getId() == (long)(this.session.getChunks().getAll().size() - 1);
    }

    public void cleanup() throws Exception {
        this.getFile().delete();
    }

    private File getFile() throws Exception {
        return new File(Chunk.getDirectory() + File.separator + this.session.getId().toString() + "_" + this.getId());
    }

    public boolean hasReceived() {
        return this.hasReceived;
    }

    private void setHasReceived(boolean received) {
        this.hasReceived = received;
    }

    public static File getDirectory() throws Exception {
        if (!Config.getFile("daemon.properties").valueExists("fileSystem.file.upload.session.chunk.directory")) {
            return FileSystem.getTmpDirectory();
        }
        return new File(Config.getFile("daemon.properties").getValue("fileSystem.file.upload.session.chunk.directory"));
    }

    public static void setDirectory(File directory) throws Exception {
        Config.getFile("daemon.properties").setValue("fileSystem.file.upload.session.chunk.directory", directory.getPath());
    }
}

