/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.interfaces.container.io;

import com.gamedash.daemon.common.listener.ListenerCallbackHandle;
import com.gamedash.daemon.docker.container.io.listener.IDockerContainerIOListener;
import com.gamedash.daemon.docker.implementation.interfaces.container.io.IDockerContainerIoImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDockerContainerIoImpl
implements IDockerContainerIoImpl {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDockerContainerIoImpl.class);
    private final List<IDockerContainerIOListener> listeners = new ArrayList<IDockerContainerIOListener>();
    private ListenerCallbackHandle<?> outputListenerCallbackHandle;

    @Override
    public List<IDockerContainerIOListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void addListener(IDockerContainerIOListener listener) {
        this.listeners.add(listener);
    }

    protected void attachListener() {
        this.outputListenerCallbackHandle = this.onOutput(item -> {
            for (IDockerContainerIOListener listener : this.getListeners()) {
                try {
                    listener.onOutput(item);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }
        });
    }

    protected void detachListener() {
        this.outputListenerCallbackHandle.destroy();
    }
}

