/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.interfaces.container;

import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.DockerExposedPort;
import com.gamedash.daemon.docker.DockerHostConfig;
import com.gamedash.daemon.docker.DockerVolume;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistry;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistryFile;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerBuilderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDockerContainerBuilder
implements IDockerContainerBuilderImpl {
    private final String imageName;
    private String name;
    private String user;
    private String hostName;
    private String workingDirectory;
    private List<String> command;
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private DockerHostConfig hostConfig;
    private List<DockerExposedPort> exposedPorts = new ArrayList<DockerExposedPort>();
    private List<DockerVolume> volumes = new ArrayList<DockerVolume>();

    public AbstractDockerContainerBuilder(String imageName) {
        this.imageName = imageName;
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void withName(String name) {
        this.name = name;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void withUser(String user) {
        this.user = user;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void withHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public void withWorkingDirectory(String directory) {
        this.workingDirectory = directory;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void withCommand(List<String> command) {
        this.command = command;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public List<String> getEnvironmentVariablesAsList() {
        ArrayList<String> list = new ArrayList<String>();
        this.getEnvironmentVariables().forEach((name, value) -> list.add(name + "=" + value));
        return list;
    }

    @Override
    public void withEnvironmentVariables(Map<String, String> env) {
        this.environmentVariables = env;
    }

    @Override
    public DockerHostConfig getHostConfig() {
        return this.hostConfig;
    }

    @Override
    public void withHostConfig(DockerHostConfig hostConfig) {
        this.hostConfig = hostConfig;
    }

    @Override
    public List<DockerExposedPort> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void withExposedPorts(List<DockerExposedPort> exposedPorts) {
        this.exposedPorts = exposedPorts;
    }

    @Override
    public List<DockerVolume> getVolumes() {
        return this.volumes;
    }

    @Override
    public void withVolumes(List<DockerVolume> volumes) {
        this.volumes = volumes;
    }

    protected void registerEntry(String id) throws Exception {
        DockerContainer container = Docker.getInstance().getContainers().get(id);
        DockerContainerRegistryFile registryFile = DockerContainerRegistry.getDefaultFile();
        if (registryFile != null) {
            registryFile.addEntry(container);
            registryFile.commit();
        }
    }
}

