/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.image;

import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.image.DockerImageImpl;
import com.gamedash.daemon.docker.implementation.interfaces.image.IDockerImageImpl;
import com.gamedash.daemon.docker.implementation.interfaces.image.IDockerImagesImpl;
import com.gamedash.daemon.docker.implementation.interfaces.repository.IDockerRepositoryImpl;
import com.github.dockerjava.api.model.Image;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class DockerImagesImpl
implements IDockerImagesImpl {
    private final DockerImpl docker;

    public DockerImagesImpl(DockerImpl docker) {
        this.docker = docker;
    }

    @Override
    public List<IDockerImageImpl> getAll() {
        ArrayList<IDockerImageImpl> images = new ArrayList<IDockerImageImpl>();
        for (Image imageModel : (List)DockerImpl.getClient().listImagesCmd().withShowAll(true).exec()) {
            images.add(new DockerImageImpl(this.docker, imageModel));
        }
        return images;
    }

    @Override
    public List<IDockerImageImpl> getRunning() {
        ArrayList<IDockerImageImpl> images = new ArrayList<IDockerImageImpl>();
        for (Image imageModel : (List)DockerImpl.getClient().listImagesCmd().withShowAll(false).exec()) {
            images.add(new DockerImageImpl(this.docker, imageModel));
        }
        return images;
    }

    @Override
    public List<IDockerImageImpl> getByRepoTag(IDockerRepositoryImpl repository, String tag) {
        ArrayList<IDockerImageImpl> images = new ArrayList<IDockerImageImpl>();
        for (IDockerImageImpl image : this.getAll()) {
            if (!ArrayUtils.contains(image.getRepoTags(), repository.getId() + ":" + tag)) continue;
            images.add(image);
        }
        return images;
    }

    @Override
    public IDockerImageImpl get(String id) {
        for (IDockerImageImpl image : this.getAll()) {
            if (!image.getId().equals(id)) continue;
            return image;
        }
        return null;
    }
}

