/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container.event;

import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.container.event.IDockerContainerEventListenerCallback;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.event.DockerContainerEventListener;
import com.gamedash.daemon.docker.implementation.interfaces.container.event.AbstractDockerContainerEventsImpl;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Event;
import java.io.Closeable;

public class DockerContainerEventsImpl
extends AbstractDockerContainerEventsImpl {
    private final DockerContainerImpl container;
    private final DockerContainerEventListener onStartEventListener = new DockerContainerEventListener();
    private final DockerContainerEventListener onKillEventListener = new DockerContainerEventListener();
    private final DockerContainerEventListener onStopEventListener = new DockerContainerEventListener();
    private final DockerContainerEventListener onDieEventListener = new DockerContainerEventListener();
    private ResultCallback<Event> handle;

    public DockerContainerEventsImpl(DockerImpl docker, DockerContainerImpl container) {
        this.container = container;
    }

    @Override
    public void listen() throws Exception {
        if (this.isListening()) {
            throw new RuntimeException("Already listening");
        }
        Time timeSince = this.container.isRunning() ? this.container.getTimeStarted() : Time.now();
        this.handle = DockerImpl.getClient().eventsCmd().withContainerFilter(this.container.getId()).withSince(Long.toString(timeSince.getTimestamp())).exec(new ResultCallback<Event>(){

            @Override
            public void onStart(Closeable closeable) {
            }

            @Override
            public void onNext(Event event) {
                String action = event.getAction();
                if (action.equals("start")) {
                    DockerContainerEventsImpl.this.invokeOnStart();
                } else if (action.equals("stop")) {
                    DockerContainerEventsImpl.this.invokeOnStop();
                } else if (action.equals("kill")) {
                    DockerContainerEventsImpl.this.invokeOnKill();
                } else if (action.equals("die")) {
                    DockerContainerEventsImpl.this.invokeOnDie();
                }
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
            }

            @Override
            public void close() {
            }
        });
        this.setIsListening(true);
    }

    @Override
    public void destroy() {
        if (!this.isListening()) {
            throw new RuntimeException("Not listening");
        }
    }

    public void ensureIsListening() throws Exception {
        if (!this.isListening()) {
            this.listen();
        }
        this.handle.close();
    }

    @Override
    public void onStart(IDockerContainerEventListenerCallback callback) {
        this.onStartEventListener.addCallback(callback);
    }

    private void invokeOnStart() {
        this.onStartEventListener.invokeAsync();
    }

    @Override
    public void onKill(IDockerContainerEventListenerCallback callback) {
        this.onKillEventListener.addCallback(callback);
    }

    private void invokeOnKill() {
        this.onKillEventListener.invokeAsync();
    }

    @Override
    public void onDie(IDockerContainerEventListenerCallback callback) {
        this.onDieEventListener.addCallback(callback);
    }

    private void invokeOnDie() {
        this.onDieEventListener.invokeAsync();
    }

    @Override
    public void onStop(IDockerContainerEventListenerCallback callback) {
        this.onStopEventListener.addCallback(callback);
    }

    private void invokeOnStop() {
        this.onStopEventListener.invokeAsync();
    }
}

