/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerNetworkImpl;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.List;

public class DockerContainerNetworkImpl
implements IDockerContainerNetworkImpl {
    private final String name;
    private final ContainerNetwork model;

    public DockerContainerNetworkImpl(DockerContainerImpl container, String name, ContainerNetwork model) {
        this.name = name;
        this.model = model;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getAliases() {
        return this.model.getAliases();
    }

    @Override
    public String getEndpointId() {
        return this.model.getEndpointId();
    }

    @Override
    public String getGateway() {
        return this.model.getGateway();
    }

    @Override
    public String getIpAddress() {
        return this.model.getIpAddress();
    }

    @Override
    public Integer getIpPrefixLen() {
        return this.model.getIpPrefixLen();
    }

    @Override
    public String getIpV6Gateway() {
        String gateway = this.model.getIpV6Gateway();
        return gateway != null && !gateway.isEmpty() ? gateway : null;
    }

    @Override
    public String getGlobalIpV6Address() {
        String address = this.model.getGlobalIPv6Address();
        return address != null && !address.isEmpty() ? address : null;
    }

    @Override
    public Integer getGlobalIpv6PrefixLen() {
        return this.model.getGlobalIPv6PrefixLen();
    }

    @Override
    public String getMacAddress() {
        return this.model.getMacAddress();
    }
}

